/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.domain.Broker;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.GetAllBrokersAck;

public class GetAllBrokersAckCodec
implements NsrPayloadCodec<GetAllBrokersAck>,
Type {
    public GetAllBrokersAck decode(Header header, ByteBuf buffer) throws Exception {
        GetAllBrokersAck allBrokersAck = new GetAllBrokersAck();
        int brokerSize = buffer.readInt();
        ArrayList<Broker> list = new ArrayList<Broker>(brokerSize);
        for (int i = 0; i < brokerSize; ++i) {
            list.add(Serializer.readBroker((ByteBuf)buffer));
        }
        allBrokersAck.brokers(list);
        return allBrokersAck;
    }

    public void encode(GetAllBrokersAck payload, ByteBuf buffer) throws Exception {
        List<Broker> brokerList = payload.getBrokers();
        if (null == brokerList || brokerList.size() < 1) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(brokerList.size());
        for (Broker broker : brokerList) {
            Serializer.write((Broker)broker, (ByteBuf)buffer);
        }
    }

    public int type() {
        return -9;
    }
}

