/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.domain.Config;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.GetAllConfigsAck;

public class GetAllConfigsAckCodec
implements NsrPayloadCodec<GetAllConfigsAck>,
Type {
    public GetAllConfigsAck decode(Header header, ByteBuf buffer) throws Exception {
        GetAllConfigsAck allConfigsAck = new GetAllConfigsAck();
        int size = buffer.readInt();
        ArrayList<Config> list = new ArrayList<Config>(size);
        for (int i = 0; i < size; ++i) {
            Config config = new Config();
            config.setGroup(Serializer.readString((ByteBuf)buffer));
            config.setKey(Serializer.readString((ByteBuf)buffer));
            config.setValue(Serializer.readString((ByteBuf)buffer));
            list.add(config);
        }
        allConfigsAck.configs(list);
        return allConfigsAck;
    }

    public void encode(GetAllConfigsAck payload, ByteBuf buffer) throws Exception {
        List<Config> configList = payload.getConfigs();
        if (null == configList || configList.size() < 0) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(configList.size());
        for (Config config : configList) {
            Serializer.write((String)config.getGroup(), (ByteBuf)buffer);
            Serializer.write((String)config.getKey(), (ByteBuf)buffer);
            Serializer.write((String)config.getValue(), (ByteBuf)buffer);
        }
    }

    public int type() {
        return -20;
    }
}

