/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.GetAllTopicsAck;

public class GetAllTopicsAckCodec
implements NsrPayloadCodec<GetAllTopicsAck>,
Type {
    public GetAllTopicsAck decode(Header header, ByteBuf buffer) throws Exception {
        GetAllTopicsAck getAllTopicsAck = new GetAllTopicsAck();
        int topicsSize = buffer.readInt();
        HashSet<String> topicNames = new HashSet<String>(topicsSize);
        for (int i = 0; i < topicsSize; ++i) {
            topicNames.add(Serializer.readString((ByteBuf)buffer));
        }
        getAllTopicsAck.topicNames(topicNames);
        return getAllTopicsAck;
    }

    public void encode(GetAllTopicsAck payload, ByteBuf buffer) throws Exception {
        Set<String> topicNames = payload.getTopicNames();
        if (null == topicNames || topicNames.size() < 1) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(topicNames.size());
        for (String topicName : topicNames) {
            Serializer.write((String)topicName, (ByteBuf)buffer);
        }
    }

    public int type() {
        return -11;
    }
}

