/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.domain.Consumer;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.GetConsumerByTopicAck;

public class GetConsumerByTopicAckCodec
implements NsrPayloadCodec<GetConsumerByTopicAck>,
Type {
    public GetConsumerByTopicAck decode(Header header, ByteBuf buffer) throws Exception {
        GetConsumerByTopicAck getConsumerByTopicAck = new GetConsumerByTopicAck();
        int size = buffer.readInt();
        ArrayList<Consumer> list = new ArrayList<Consumer>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Serializer.readConsumer((int)header.getVersion(), (ByteBuf)buffer));
        }
        getConsumerByTopicAck.consumers(list);
        return getConsumerByTopicAck;
    }

    public void encode(GetConsumerByTopicAck payload, ByteBuf buffer) throws Exception {
        List<Consumer> consumers = payload.getConsumers();
        if (null == consumers || consumers.size() < 1) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(consumers.size());
        for (Consumer consumer : consumers) {
            Serializer.write((int)payload.getHeader().getVersion(), (Consumer)consumer, (ByteBuf)buffer);
        }
    }

    public int type() {
        return -22;
    }
}

