/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.domain.Producer;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.GetProducerByTopicAck;

public class GetProducerByTopicAckCodec
implements NsrPayloadCodec<GetProducerByTopicAck>,
Type {
    public GetProducerByTopicAck decode(Header header, ByteBuf buffer) throws Exception {
        GetProducerByTopicAck getProducerByTopicAck = new GetProducerByTopicAck();
        int size = buffer.readInt();
        ArrayList<Producer> list = new ArrayList<Producer>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Serializer.readProducer((int)header.getVersion(), (ByteBuf)buffer));
        }
        getProducerByTopicAck.producers(list);
        return getProducerByTopicAck;
    }

    public void encode(GetProducerByTopicAck payload, ByteBuf buffer) throws Exception {
        List<Producer> producers = payload.getProducers();
        if (null == producers) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(producers.size());
        for (Producer producer : producers) {
            Serializer.write((int)payload.getHeader().getVersion(), (Producer)producer, (ByteBuf)buffer);
        }
    }

    public int type() {
        return -23;
    }
}

