/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.TopicName;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.GetReplicaByBrokerAck;

public class GetReplicaByBrokerAckCodec
implements NsrPayloadCodec<GetReplicaByBrokerAck>,
Type {
    public GetReplicaByBrokerAck decode(Header header, ByteBuf buffer) throws Exception {
        GetReplicaByBrokerAck getReplicaByBrokerAck = new GetReplicaByBrokerAck();
        int size = buffer.readInt();
        ArrayList<Replica> list = new ArrayList<Replica>(size);
        for (int i = 0; i < size; ++i) {
            Replica replica = new Replica();
            replica.setGroup(buffer.readInt());
            replica.setBrokerId(buffer.readInt());
            replica.setId(Serializer.readString((ByteBuf)buffer));
            replica.setTopic(TopicName.parse((String)Serializer.readString((ByteBuf)buffer)));
            list.add(replica);
        }
        getReplicaByBrokerAck.replicas(list);
        return getReplicaByBrokerAck;
    }

    public void encode(GetReplicaByBrokerAck payload, ByteBuf buffer) throws Exception {
        List<Replica> replicas = payload.getReplicas();
        if (null == replicas) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(replicas.size());
        for (Replica replica : replicas) {
            buffer.writeInt(replica.getGroup());
            buffer.writeInt(replica.getBrokerId());
            Serializer.write((String)replica.getId(), (ByteBuf)buffer);
            Serializer.write((String)replica.getTopic().getFullName(), (ByteBuf)buffer);
        }
    }

    public int type() {
        return -24;
    }
}

