/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.GetTopicConfigByAppAck;

public class GetTopicConfigByAppAckCodec
implements NsrPayloadCodec<GetTopicConfigByAppAck>,
Type {
    public Object decode(Header header, ByteBuf buffer) throws Exception {
        GetTopicConfigByAppAck getTopicConfigByBrokerAck = new GetTopicConfigByAppAck();
        int topicSize = buffer.readInt();
        HashMap<TopicName, TopicConfig> topicConfigs = new HashMap<TopicName, TopicConfig>(topicSize);
        for (int i = 0; i < topicSize; ++i) {
            TopicConfig topicConfig = Serializer.readTopicConfig((ByteBuf)buffer, (int)header.getVersion());
            topicConfigs.put(topicConfig.getName(), topicConfig);
        }
        getTopicConfigByBrokerAck.topicConfigs(topicConfigs);
        return getTopicConfigByBrokerAck;
    }

    public void encode(GetTopicConfigByAppAck payload, ByteBuf buffer) throws Exception {
        Map<TopicName, TopicConfig> topicConfigs = payload.getTopicConfigs();
        if (null == topicConfigs) {
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(topicConfigs.size());
        for (TopicConfig topicConfig : topicConfigs.values()) {
            Serializer.write((TopicConfig)topicConfig, (ByteBuf)buffer, (int)payload.getHeader().getVersion());
        }
    }

    public int type() {
        return -17;
    }
}

