/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.TreeSet;
import org.joyqueue.domain.TopicName;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.LeaderReport;

public class LeaderReportCodec
implements NsrPayloadCodec<LeaderReport>,
Type {
    public LeaderReport decode(Header header, ByteBuf buffer) throws Exception {
        LeaderReport leaderReport = new LeaderReport();
        leaderReport.topic(TopicName.parse((String)Serializer.readString((ByteBuf)buffer)));
        leaderReport.partitionGroup(buffer.readInt());
        leaderReport.leaderBrokerId(buffer.readInt());
        leaderReport.termId(buffer.readInt());
        boolean hasIsr = buffer.readBoolean();
        if (hasIsr) {
            int isrSize = buffer.readInt();
            TreeSet<Integer> isrs = new TreeSet<Integer>();
            for (int i = 0; i < isrSize; ++i) {
                isrs.add(buffer.readInt());
            }
            leaderReport.isrId(isrs);
        }
        return leaderReport;
    }

    public void encode(LeaderReport payload, ByteBuf buffer) throws Exception {
        Serializer.write((String)payload.getTopic().getFullName(), (ByteBuf)buffer);
        buffer.writeInt(payload.getPartitionGroup());
        buffer.writeInt(payload.getLeaderBrokerId());
        buffer.writeInt(payload.getTermId());
        if (null == payload.getIsrId()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeInt(payload.getIsrId().size());
            for (Integer isr : payload.getIsrId()) {
                buffer.writeInt(isr.intValue());
            }
        }
    }

    public int type() {
        return 6;
    }
}

