/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Types;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.CreatePartitionGroup;
import org.joyqueue.nsr.network.command.OperatePartitionGroup;
import org.joyqueue.nsr.network.command.RemovePartitionGroup;
import org.joyqueue.nsr.network.command.UpdatePartitionGroup;

public class OperatePartitionGroupCodec
implements NsrPayloadCodec<OperatePartitionGroup>,
Types {
    private static final int[] types = new int[]{127, 126, 125, 124};

    public Object decode(Header header, ByteBuf buffer) throws Exception {
        PartitionGroup group = Serializer.readPartitionGroup((ByteBuf)buffer, (int)header.getVersion());
        boolean rollback = buffer.readBoolean();
        int cmdType = header.getType();
        if (cmdType == 127) {
            return new CreatePartitionGroup(group, rollback);
        }
        if (cmdType == 126 || cmdType == 124) {
            return new UpdatePartitionGroup(group, rollback);
        }
        if (cmdType == 125) {
            return new RemovePartitionGroup(group, rollback);
        }
        if (cmdType == 124) {
            return new UpdatePartitionGroup(group, rollback);
        }
        return null;
    }

    public int[] types() {
        return types;
    }

    public void encode(OperatePartitionGroup payload, ByteBuf buffer) throws Exception {
        PartitionGroup partitionGroup = payload.getPartitionGroup();
        Serializer.write((PartitionGroup)partitionGroup, (ByteBuf)buffer, (int)payload.getHeader().getVersion());
        buffer.writeBoolean(payload.isRollback());
    }
}

