/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.codec;

import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.network.NsrPayloadCodec;
import org.joyqueue.nsr.network.command.PushNameServerEvent;

public class PushNameServerEventCodec
implements NsrPayloadCodec<PushNameServerEvent>,
Type {
    public PushNameServerEvent decode(Header header, ByteBuf buffer) throws Exception {
        int brokerId = buffer.readInt();
        String eventValue = Serializer.readString((ByteBuf)buffer, (int)2);
        String typeName = Serializer.readString((ByteBuf)buffer);
        if (typeName.startsWith("com.jd.journalq")) {
            typeName = typeName.replace("com.jd.journalq", "org.joyqueue");
        }
        return new PushNameServerEvent().event(new NameServerEvent((MetaEvent)JSON.parseObject((String)eventValue, Class.forName(typeName)), Integer.valueOf(brokerId)));
    }

    public void encode(PushNameServerEvent payload, ByteBuf buffer) throws Exception {
        if (payload.getHeader().getVersion() >= 3) {
            NameServerEvent event = payload.getEvent();
            buffer.writeInt(event.getBrokerId().intValue());
            Serializer.write((String)JSON.toJSONString((Object)event.getMetaEvent()), (ByteBuf)buffer, (int)2);
            Serializer.write((String)event.getMetaEvent().getTypeName(), (ByteBuf)buffer);
        } else if (payload.getHeader().getVersion() >= 1) {
            NameServerEvent event = payload.getEvent();
            buffer.writeInt(event.getBrokerId().intValue());
            Serializer.write((String)JSON.toJSONString((Object)event.getMetaEvent()), (ByteBuf)buffer, (int)2);
            Serializer.write((String)event.getMetaEvent().getTypeName().replace("org.joyqueue", "com.jd.journalq"), (ByteBuf)buffer);
        }
    }

    public int type() {
        return 26;
    }
}

