/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jd.laf.extension.Type;
import java.util.HashSet;
import java.util.List;
import org.joyqueue.domain.AllMetadata;
import org.joyqueue.domain.Config;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Types;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.network.NsrCommandHandler;
import org.joyqueue.nsr.network.codec.GetAllMetadataResponseCodec;
import org.joyqueue.nsr.network.command.GetAllMetadataRequest;
import org.joyqueue.nsr.network.command.GetAllMetadataResponse;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAllMetadataRequestHandler
implements NsrCommandHandler,
PropertySupplierAware,
Types,
Type<String> {
    protected static final Logger logger = LoggerFactory.getLogger(GetAllMetadataRequestHandler.class);
    private PropertySupplier supplier;
    private NameServiceConfig config;
    private NameService nameService;
    private volatile AllMetadata allMetadataCache;
    private volatile byte[] allMetadataCacheByte;
    private Thread refreshCacheThread;

    public void setSupplier(PropertySupplier supplier) {
        this.supplier = supplier;
        this.config = new NameServiceConfig(supplier);
    }

    @Override
    public void setNameService(NameService nameService) {
        this.nameService = nameService;
        this.refreshCacheThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        if (this.config.getAllMetadataCacheEnable()) {
                            this.allMetadataCacheByte = this.doGetAllMetadata();
                        }
                        Thread.currentThread();
                        Thread.sleep(this.config.getAllMetadataCacheExpireTime());
                    }
                }
                catch (Exception e) {
                    logger.error("refresh cache exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }, "joyqueue-allmetadata-cache-refresh-thread");
        this.refreshCacheThread.setDaemon(true);
        this.refreshCacheThread.start();
    }

    public Command handle(Transport transport, Command command) {
        GetAllMetadataRequest getAllMetadataRequest = (GetAllMetadataRequest)((Object)command.getPayload());
        byte[] response = null;
        if (this.config.getAllMetadataCacheEnable()) {
            if (this.allMetadataCacheByte == null) {
                this.allMetadataCacheByte = this.doGetAllMetadata();
            }
            response = this.allMetadataCacheByte;
        } else {
            response = this.doGetAllMetadata();
        }
        GetAllMetadataResponse getAllMetadataResponse = new GetAllMetadataResponse();
        getAllMetadataResponse.setResponse(response);
        return new Command((Object)getAllMetadataResponse);
    }

    protected byte[] doGetAllMetadata() {
        boolean isException = false;
        try {
            this.allMetadataCache = this.nameService.getAllMetadata();
        }
        catch (Exception e) {
            if (this.allMetadataCache == null) {
                throw e;
            }
            isException = true;
            logger.error("get all metadata exception", (Throwable)e);
        }
        if (isException || this.config.getAllMetadataRewriteEnable()) {
            this.allMetadataCache.setConfigs(this.mergeMemoryConfigs(this.allMetadataCache.getConfigs()));
        }
        return GetAllMetadataResponseCodec.toJson(this.allMetadataCache);
    }

    protected List<Config> mergeMemoryConfigs(List<Config> configs) {
        HashSet result = Sets.newHashSet();
        result.addAll(configs);
        List properties = this.supplier.getProperties();
        for (Property property : properties) {
            if (!"all".equals(property.getGroup())) continue;
            result.add(new Config(property.getGroup(), property.getKey(), String.valueOf(property.getValue())));
        }
        return Lists.newArrayList((Iterable)result);
    }

    public String type() {
        return "SERVER";
    }

    public int[] types() {
        return new int[]{52};
    }
}

