/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.network.handler;

import com.jd.laf.extension.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.NameServerEvent;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.Authorization;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.GetTopics;
import org.joyqueue.network.command.GetTopicsAck;
import org.joyqueue.network.command.Subscribe;
import org.joyqueue.network.command.SubscribeAck;
import org.joyqueue.network.command.UnSubscribe;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportAttribute;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Types;
import org.joyqueue.network.transport.command.provider.ExecutorServiceProvider;
import org.joyqueue.network.transport.support.DefaultTransportAttribute;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.message.MessageListener;
import org.joyqueue.nsr.network.NsrCommandHandler;
import org.joyqueue.nsr.network.command.AddTopic;
import org.joyqueue.nsr.network.command.GetAllBrokersAck;
import org.joyqueue.nsr.network.command.GetAllConfigsAck;
import org.joyqueue.nsr.network.command.GetAllTopicsAck;
import org.joyqueue.nsr.network.command.GetAppToken;
import org.joyqueue.nsr.network.command.GetAppTokenAck;
import org.joyqueue.nsr.network.command.GetBroker;
import org.joyqueue.nsr.network.command.GetBrokerAck;
import org.joyqueue.nsr.network.command.GetBrokerByRetryType;
import org.joyqueue.nsr.network.command.GetBrokerByRetryTypeAck;
import org.joyqueue.nsr.network.command.GetConfig;
import org.joyqueue.nsr.network.command.GetConfigAck;
import org.joyqueue.nsr.network.command.GetConsumerByTopic;
import org.joyqueue.nsr.network.command.GetConsumerByTopicAck;
import org.joyqueue.nsr.network.command.GetConsumerByTopicAndApp;
import org.joyqueue.nsr.network.command.GetConsumerByTopicAndAppAck;
import org.joyqueue.nsr.network.command.GetDataCenter;
import org.joyqueue.nsr.network.command.GetDataCenterAck;
import org.joyqueue.nsr.network.command.GetProducerByTopic;
import org.joyqueue.nsr.network.command.GetProducerByTopicAck;
import org.joyqueue.nsr.network.command.GetProducerByTopicAndApp;
import org.joyqueue.nsr.network.command.GetProducerByTopicAndAppAck;
import org.joyqueue.nsr.network.command.GetReplicaByBroker;
import org.joyqueue.nsr.network.command.GetReplicaByBrokerAck;
import org.joyqueue.nsr.network.command.GetTopicConfig;
import org.joyqueue.nsr.network.command.GetTopicConfigAck;
import org.joyqueue.nsr.network.command.GetTopicConfigByApp;
import org.joyqueue.nsr.network.command.GetTopicConfigByAppAck;
import org.joyqueue.nsr.network.command.GetTopicConfigByBroker;
import org.joyqueue.nsr.network.command.GetTopicConfigByBrokerAck;
import org.joyqueue.nsr.network.command.HasSubscribe;
import org.joyqueue.nsr.network.command.HasSubscribeAck;
import org.joyqueue.nsr.network.command.LeaderReport;
import org.joyqueue.nsr.network.command.LeaderReportAck;
import org.joyqueue.nsr.network.command.NsrConnection;
import org.joyqueue.nsr.network.command.PushNameServerEvent;
import org.joyqueue.nsr.network.command.Register;
import org.joyqueue.nsr.network.command.RegisterAck;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServiceCommandHandler
implements NsrCommandHandler,
Types,
Type<String>,
EventListener<TransportEvent>,
PropertySupplierAware,
ExecutorServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(NameServiceCommandHandler.class);
    private NameService nameService;
    private NameServiceConfig config;
    private final Map<Integer, Transport> nsrClients = new ConcurrentHashMap<Integer, Transport>();
    private ExecutorService executeThreadPool;

    public void setSupplier(PropertySupplier supplier) {
        this.config = new NameServiceConfig(supplier);
        this.executeThreadPool = new ThreadPoolExecutor(this.config.getHandlerThreads(), this.config.getHandlerThreads(), (long)this.config.getHandlerKeepalive(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.config.getHandlerQueues()), (ThreadFactory)new NamedThreadFactory("joyqueue-nameservice-handler"));
    }

    public ExecutorService getExecutorService(Transport transport, Command command) {
        return this.executeThreadPool;
    }

    public int[] types() {
        return new int[]{27, 9, 20, 11, 25, 21, 8, 19, 16, 22, 18, 15, 23, 24, 17, 13, 10, 41, 7, 6, 102, 14, 100, 101, 103, 0};
    }

    public Command handle(Transport transport, Command command) {
        Command response = null;
        switch (command.getHeader().getType()) {
            case 27: {
                AddTopic addTopic = (AddTopic)((Object)command.getPayload());
                this.nameService.addTopic(addTopic.getTopic(), addTopic.getPartitionGroups());
                response = BooleanAck.build();
                break;
            }
            case 9: {
                response = new Command((Object)new GetAllBrokersAck().brokers(this.nameService.getAllBrokers()));
                break;
            }
            case 20: {
                response = new Command((Object)new GetAllConfigsAck().configs(this.nameService.getAllConfigs()));
                break;
            }
            case 11: {
                response = new Command((Object)new GetAllTopicsAck().topicNames(this.nameService.getAllTopicCodes()));
                break;
            }
            case 25: {
                GetAppToken getAppToken = (GetAppToken)((Object)command.getPayload());
                AppToken appToken = this.nameService.getAppToken(getAppToken.getApp(), getAppToken.getToken());
                response = new Command((Object)new GetAppTokenAck().appToken(appToken));
                break;
            }
            case 21: {
                GetBrokerByRetryType getBrokerByRetryType = (GetBrokerByRetryType)((Object)command.getPayload());
                List<Broker> brokers = this.nameService.getBrokerByRetryType(getBrokerByRetryType.getRetryType());
                response = new Command((Object)new GetBrokerByRetryTypeAck().brokers(brokers));
                break;
            }
            case 8: {
                GetBroker getBroker = (GetBroker)((Object)command.getPayload());
                Broker broker = this.nameService.getBroker(getBroker.getBrokerId());
                response = new Command((Object)new GetBrokerAck().broker(broker));
                break;
            }
            case 19: {
                GetConfig getConfig = (GetConfig)((Object)command.getPayload());
                String value = this.nameService.getConfig(getConfig.getGroup(), getConfig.getKey());
                response = new Command((Object)new GetConfigAck().value(value));
                break;
            }
            case 16: {
                GetConsumerByTopicAndApp getConsumerByTopicAndApp = (GetConsumerByTopicAndApp)((Object)command.getPayload());
                Consumer consumer = this.nameService.getConsumerByTopicAndApp(getConsumerByTopicAndApp.getTopic(), getConsumerByTopicAndApp.getApp());
                response = new Command((Object)new GetConsumerByTopicAndAppAck().consumer(consumer));
                break;
            }
            case 22: {
                GetConsumerByTopic getConsumerByTopic = (GetConsumerByTopic)((Object)command.getPayload());
                List<Consumer> consumers = this.nameService.getConsumerByTopic(getConsumerByTopic.getTopic());
                response = new Command((Object)new GetConsumerByTopicAck().consumers(consumers));
                break;
            }
            case 18: {
                GetDataCenter getDataCenter = (GetDataCenter)((Object)command.getPayload());
                DataCenter dataCenter = this.nameService.getDataCenter(getDataCenter.getIp());
                response = new Command((Object)new GetDataCenterAck().dataCenter(dataCenter));
                break;
            }
            case 15: {
                GetProducerByTopicAndApp getProducerByTopicAndApp = (GetProducerByTopicAndApp)((Object)command.getPayload());
                Producer producer = this.nameService.getProducerByTopicAndApp(getProducerByTopicAndApp.getTopic(), getProducerByTopicAndApp.getApp());
                response = new Command((Object)new GetProducerByTopicAndAppAck().producer(producer));
                break;
            }
            case 23: {
                GetProducerByTopic getProducerByTopic = (GetProducerByTopic)((Object)command.getPayload());
                List<Producer> producers = this.nameService.getProducerByTopic(getProducerByTopic.getTopic());
                response = new Command((Object)new GetProducerByTopicAck().producers(producers));
                break;
            }
            case 24: {
                GetReplicaByBroker getReplicaByBroker = (GetReplicaByBroker)((Object)command.getPayload());
                List<Replica> replicas = this.nameService.getReplicaByBroker(getReplicaByBroker.getBrokerId());
                response = new Command((Object)new GetReplicaByBrokerAck().replicas(replicas));
                break;
            }
            case 17: {
                GetTopicConfigByApp getTopicConfigByApp = (GetTopicConfigByApp)((Object)command.getPayload());
                Map<TopicName, TopicConfig> topicConfigs = this.nameService.getTopicConfigByApp(getTopicConfigByApp.getApp(), getTopicConfigByApp.getSubscribe());
                response = new Command((Object)new GetTopicConfigByAppAck().topicConfigs(topicConfigs));
                break;
            }
            case 13: {
                GetTopicConfigByBroker getTopicConfigByBroker = (GetTopicConfigByBroker)((Object)command.getPayload());
                Map<TopicName, TopicConfig> topicConfigByBroker = this.nameService.getTopicConfigByBroker(getTopicConfigByBroker.getBrokerId());
                response = new Command((Object)new GetTopicConfigByBrokerAck().topicConfigs(topicConfigByBroker));
                break;
            }
            case 10: {
                GetTopicConfig getTopicConfig = (GetTopicConfig)((Object)command.getPayload());
                TopicConfig topicConfig = this.nameService.getTopicConfig(getTopicConfig.getTopic());
                response = new Command((Object)new GetTopicConfigAck().topicConfig(topicConfig));
                break;
            }
            case 41: 
            case 102: {
                GetTopics getTopics = (GetTopics)command.getPayload();
                Set<String> topicNames = null;
                topicNames = StringUtils.isBlank((CharSequence)getTopics.getApp()) ? this.nameService.getAllTopicCodes() : this.nameService.getTopics(getTopics.getApp(), Subscription.Type.valueOf((byte)((byte)getTopics.getSubscribeType())));
                response = new Command((Header)new JoyQueueHeader(Direction.RESPONSE, command.getHeader().getType() == 102 ? -102 : -41), (Object)new GetTopicsAck().topics(topicNames));
                break;
            }
            case 7: {
                HasSubscribe hasSubscribe = (HasSubscribe)((Object)command.getPayload());
                response = new Command((Object)new HasSubscribeAck().have(this.nameService.hasSubscribe(hasSubscribe.getApp(), hasSubscribe.getSubscribe())));
                break;
            }
            case 6: {
                LeaderReport leaderReport = (LeaderReport)((Object)command.getPayload());
                logger.info("Name service receive leader report command {} from {}", (Object)leaderReport, (Object)transport.remoteAddress());
                this.nameService.leaderReport(leaderReport.getTopic(), leaderReport.getPartitionGroup(), leaderReport.getLeaderBrokerId(), leaderReport.getIsrId(), leaderReport.getTermId());
                response = new Command((Object)new LeaderReportAck());
                break;
            }
            case 14: {
                Register register = (Register)((Object)command.getPayload());
                Broker brokerRegister = this.nameService.register(register.getBrokerId(), register.getBrokerIp(), register.getPort());
                if (null != brokerRegister) {
                    this.fillTransportBrokerId(transport, brokerRegister.getId());
                    response = new Command((Object)new RegisterAck().broker(brokerRegister));
                    break;
                }
                response = BooleanAck.build((JoyQueueCode)JoyQueueCode.NSR_REGISTER_ERR_BROKER_NOT_EXIST, (Object[])new Object[0]);
                break;
            }
            case 100: {
                Subscribe subscribe = (Subscribe)command.getPayload();
                List<TopicConfig> subscribeTopicConfigs = this.nameService.subscribe(subscribe.getSubscriptions(), subscribe.getClientType());
                response = new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -100), (Object)new SubscribeAck().topicConfigs(subscribeTopicConfigs));
                break;
            }
            case 101: {
                UnSubscribe unSubscribe = (UnSubscribe)command.getPayload();
                this.nameService.unSubscribe(unSubscribe.getSubscriptions());
                response = BooleanAck.build();
                break;
            }
            case 103: {
                Authorization authorization = (Authorization)command.getPayload();
                Date now = Calendar.getInstance().getTime();
                AppToken appTokenforAuth = this.nameService.getAppToken(authorization.getApp(), authorization.getToken());
                response = null != appTokenforAuth && appTokenforAuth.getEffectiveTime().before(now) && appTokenforAuth.getExpirationTime().after(now) ? BooleanAck.build() : BooleanAck.build((JoyQueueCode)JoyQueueCode.CN_AUTHENTICATION_ERROR, (Object[])new Object[0]);
                break;
            }
            case 0: {
                Integer brokerId = ((NsrConnection)((Object)command.getPayload())).getBrokerId();
                this.fillTransportBrokerId(transport, brokerId);
                response = BooleanAck.build();
                break;
            }
            default: {
                response = BooleanAck.build((JoyQueueCode)JoyQueueCode.CN_UNKNOWN_ERROR, (Object[])new Object[]{"unRecognize command "});
            }
        }
        return response;
    }

    @Override
    public void setNameService(NameService nameService) {
        this.nameService = nameService;
        this.nameService.addListener(new PushMetaEventListener());
    }

    public String type() {
        return "SERVER";
    }

    private void fillTransportBrokerId(Transport transport, int brokerId) {
        TransportAttribute attribute = transport.attr();
        if (attribute == null) {
            attribute = new DefaultTransportAttribute();
            transport.attr(attribute);
        }
        attribute.set((Object)"broker.id", (Object)brokerId);
        this.nsrClients.put(brokerId, transport);
        logger.info("{} online", (Object)brokerId);
    }

    public void onEvent(TransportEvent event) {
        Transport transport = event.getTransport();
        Integer brokerId = (Integer)transport.attr().get((Object)"broker.id");
        if (null == brokerId || 0 == brokerId) {
            return;
        }
        switch (event.getType()) {
            case CONNECT: {
                this.nsrClients.put(brokerId, transport);
                logger.info("{} online", (Object)brokerId);
                break;
            }
            case EXCEPTION: 
            case CLOSE: {
                this.nsrClients.remove((int)brokerId);
                logger.info("{} offline", (Object)brokerId);
                break;
            }
        }
    }

    protected class PushMetaEventListener
    implements MessageListener<NameServerEvent> {
        private final Logger logger = LoggerFactory.getLogger(PushMetaEventListener.class);

        protected PushMetaEventListener() {
        }

        public void onEvent(NameServerEvent event) {
            try {
                this.logger.info("will publish event [{}]", (Object)event);
                if (event == null || event.getBrokerId() == null) {
                    this.logger.warn("broker is null.");
                } else if (NameServiceCommandHandler.this.nsrClients == null || NameServiceCommandHandler.this.nsrClients.isEmpty()) {
                    this.logger.warn("nsr client is null.");
                } else {
                    Integer brokerId = event.getBrokerId();
                    if (event.getBrokerId() == NameServerEvent.BROKER_ID_ALL_BROKER) {
                        this.sendEvent(event, NameServiceCommandHandler.this.nsrClients.values().toArray(new Transport[NameServiceCommandHandler.this.nsrClients.size()]));
                    } else {
                        Transport transport = (Transport)NameServiceCommandHandler.this.nsrClients.get(brokerId);
                        if (transport != null) {
                            this.sendEvent(event, transport);
                        } else {
                            this.logger.warn("transport is null.brokerId[{}]", (Object)brokerId);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("push event to [{}] error", (Object)event.getBrokerId(), (Object)e);
            }
        }

        private void sendEvent(final NameServerEvent event, Transport ... transports) {
            if (transports == null) {
                return;
            }
            for (Transport transport : transports) {
                transport.async(new Command((Header)new JoyQueueHeader(Direction.REQUEST, 26), (Object)new PushNameServerEvent().event(event)), new CommandCallback(){

                    public void onSuccess(Command request, Command response) {
                        PushMetaEventListener.this.logger.info("event[{}] send to [{}] success", (Object)event, (Object)event.getBrokerId());
                    }

                    public void onException(Command request, Throwable cause) {
                        PushMetaEventListener.this.logger.info("event[{}] send to [{}] failure.", (Object)event, (Object)event.getBrokerId());
                    }
                });
            }
        }
    }
}

