/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.support;

import java.util.List;
import org.joyqueue.domain.Broker;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.event.UpdateBrokerEvent;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.message.Messenger;
import org.joyqueue.nsr.model.BrokerQuery;
import org.joyqueue.nsr.service.BrokerService;
import org.joyqueue.nsr.service.internal.BrokerInternalService;
import org.joyqueue.nsr.service.internal.TransactionInternalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBrokerService
implements BrokerService {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultBrokerService.class);
    private BrokerInternalService brokerInternalService;
    private TransactionInternalService transactionInternalService;
    private NameServiceConfig config;
    private Messenger messenger;

    public DefaultBrokerService(BrokerInternalService brokerInternalService, TransactionInternalService transactionInternalService, NameServiceConfig config, Messenger messenger) {
        this.brokerInternalService = brokerInternalService;
        this.transactionInternalService = transactionInternalService;
        this.config = config;
        this.messenger = messenger;
    }

    @Override
    public Broker getById(int id) {
        return this.brokerInternalService.getById(id);
    }

    @Override
    public Broker getByIpAndPort(String brokerIp, Integer brokerPort) {
        return this.brokerInternalService.getByIpAndPort(brokerIp, brokerPort);
    }

    @Override
    public List<Broker> getByRetryType(String retryType) {
        return this.brokerInternalService.getByRetryType(retryType);
    }

    @Override
    public List<Broker> getByIds(List<Integer> ids) {
        return this.brokerInternalService.getByIds(ids);
    }

    @Override
    public List<Broker> getAll() {
        return this.brokerInternalService.getAll();
    }

    @Override
    public PageResult<Broker> search(QPageQuery<BrokerQuery> pageQuery) {
        return this.brokerInternalService.search(pageQuery);
    }

    @Override
    public Broker add(Broker broker) {
        return this.brokerInternalService.add(broker);
    }

    @Override
    public Broker update(Broker broker) {
        Broker oldBroker = this.brokerInternalService.getById(broker.getId());
        if (oldBroker == null) {
            throw new NsrException(String.format("broker: %s is not exist", broker.getId()));
        }
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, id: {}", (Object)broker.getId(), (Object)e);
            throw new NsrException(e);
        }
        logger.info("updateBroker, id: {}", (Object)broker.getId());
        try {
            this.brokerInternalService.update(broker);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("updateBroker exception, broker: {}", (Object)broker, (Object)e);
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishBrokerEnable()) {
            this.messenger.publish(new UpdateBrokerEvent(oldBroker, broker), broker);
        }
        return broker;
    }

    @Override
    public void delete(int id) {
        this.brokerInternalService.delete(id);
    }
}

