/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.event.AddConsumerEvent;
import org.joyqueue.nsr.event.RemoveConsumerEvent;
import org.joyqueue.nsr.event.UpdateConsumerEvent;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.message.Messenger;
import org.joyqueue.nsr.service.ConsumerService;
import org.joyqueue.nsr.service.internal.BrokerInternalService;
import org.joyqueue.nsr.service.internal.ConsumerInternalService;
import org.joyqueue.nsr.service.internal.PartitionGroupInternalService;
import org.joyqueue.nsr.service.internal.TopicInternalService;
import org.joyqueue.nsr.service.internal.TransactionInternalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumerService
implements ConsumerService {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultConsumerService.class);
    private TopicInternalService topicInternalService;
    private PartitionGroupInternalService partitionGroupInternalService;
    private BrokerInternalService brokerInternalService;
    private ConsumerInternalService consumerInternalService;
    private TransactionInternalService transactionInternalService;
    private NameServiceConfig config;
    private Messenger messenger;

    public DefaultConsumerService(TopicInternalService topicInternalService, PartitionGroupInternalService partitionGroupInternalService, BrokerInternalService brokerInternalService, ConsumerInternalService consumerInternalService, TransactionInternalService transactionInternalService, NameServiceConfig config, Messenger messenger) {
        this.topicInternalService = topicInternalService;
        this.partitionGroupInternalService = partitionGroupInternalService;
        this.brokerInternalService = brokerInternalService;
        this.consumerInternalService = consumerInternalService;
        this.transactionInternalService = transactionInternalService;
        this.config = config;
        this.messenger = messenger;
    }

    @Override
    public Consumer getById(String id) {
        return this.consumerInternalService.getById(id);
    }

    @Override
    public Consumer getByTopicAndApp(TopicName topic, String app) {
        return this.consumerInternalService.getByTopicAndApp(topic, app);
    }

    @Override
    public List<Consumer> getByTopic(TopicName topic) {
        return this.consumerInternalService.getByTopic(topic);
    }

    @Override
    public List<Consumer> getByApp(String app) {
        return this.consumerInternalService.getByApp(app);
    }

    @Override
    public List<Consumer> getAll() {
        return this.consumerInternalService.getAll();
    }

    @Override
    public Consumer add(Consumer consumer) {
        if (this.topicInternalService.getTopicByCode(consumer.getTopic().getNamespace(), consumer.getTopic().getCode()) == null) {
            throw new NsrException(String.format("topic: %s is not exist", consumer.getTopic()));
        }
        if (this.consumerInternalService.getByTopicAndApp(consumer.getTopic(), consumer.getApp()) != null) {
            throw new NsrException(String.format("consumer: %s,%s is exist", consumer.getTopic(), consumer.getApp()));
        }
        logger.info("addConsumer, topic: {}, app: {}", (Object)consumer.getTopic(), (Object)consumer.getApp());
        List<PartitionGroup> partitionGroups = this.partitionGroupInternalService.getByTopic(consumer.getTopic());
        List<Broker> replicas = this.getReplicas(partitionGroups);
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, app: {}", new Object[]{consumer.getTopic(), consumer.getApp(), e});
            throw new NsrException(e);
        }
        try {
            this.consumerInternalService.add(consumer);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("addConsumer exception, topic: {}, app: {}", new Object[]{consumer.getTopic(), consumer.getApp(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishSubscriptionEnable()) {
            this.messenger.publish(new AddConsumerEvent(consumer.getTopic(), consumer), replicas);
        }
        return consumer;
    }

    @Override
    public Consumer update(Consumer consumer) {
        Consumer oldConsumer = this.consumerInternalService.getByTopicAndApp(consumer.getTopic(), consumer.getApp());
        if (oldConsumer == null) {
            throw new NsrException(String.format("topic: %s, consumer: %s is not exist", oldConsumer.getTopic(), oldConsumer.getApp()));
        }
        logger.info("updateConsumer, topic: {}, app: {}", (Object)consumer.getTopic(), (Object)consumer.getApp());
        List<PartitionGroup> partitionGroups = this.partitionGroupInternalService.getByTopic(consumer.getTopic());
        List<Broker> replicas = this.getReplicas(partitionGroups);
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, app: {}", new Object[]{consumer.getTopic(), consumer.getApp(), e});
            throw new NsrException(e);
        }
        try {
            this.consumerInternalService.update(consumer);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("updateConsumer exception, topic: {}, app: {}", new Object[]{consumer.getTopic(), consumer.getApp(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishSubscriptionEnable()) {
            this.messenger.publish(new UpdateConsumerEvent(consumer.getTopic(), oldConsumer, consumer), replicas);
        }
        return consumer;
    }

    @Override
    public void delete(String id) {
        Consumer consumer = this.consumerInternalService.getById(id);
        if (consumer == null) {
            throw new NsrException(String.format("consumer: %s is not exist", id));
        }
        logger.info("deleteConsumer, topic: {}, app: {}", (Object)consumer.getTopic(), (Object)consumer.getApp());
        List<PartitionGroup> partitionGroups = this.partitionGroupInternalService.getByTopic(consumer.getTopic());
        List<Broker> replicas = this.getReplicas(partitionGroups);
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, app: {}", new Object[]{consumer.getTopic(), consumer.getApp(), e});
            throw new NsrException(e);
        }
        try {
            this.consumerInternalService.delete(id);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("deleteConsumer exception, topic: {}, app: {}", new Object[]{consumer.getTopic(), consumer.getApp(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishSubscriptionEnable()) {
            this.messenger.publish(new RemoveConsumerEvent(consumer.getTopic(), consumer), replicas);
        }
    }

    protected List<Broker> getReplicas(List<PartitionGroup> partitionGroups) {
        if (CollectionUtils.isEmpty(partitionGroups)) {
            return null;
        }
        HashSet replicaIds = Sets.newHashSet();
        for (PartitionGroup partitionGroup : partitionGroups) {
            if (partitionGroup.getReplicas() != null) {
                replicaIds.addAll(partitionGroup.getReplicas());
            }
            if (partitionGroup.getLearners() == null) continue;
            replicaIds.addAll(partitionGroup.getLearners());
        }
        return this.brokerInternalService.getByIds(Lists.newArrayList((Iterable)replicaIds));
    }
}

