/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.event.AddProducerEvent;
import org.joyqueue.nsr.event.RemoveProducerEvent;
import org.joyqueue.nsr.event.UpdateProducerEvent;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.message.Messenger;
import org.joyqueue.nsr.service.ProducerService;
import org.joyqueue.nsr.service.internal.BrokerInternalService;
import org.joyqueue.nsr.service.internal.PartitionGroupInternalService;
import org.joyqueue.nsr.service.internal.ProducerInternalService;
import org.joyqueue.nsr.service.internal.TopicInternalService;
import org.joyqueue.nsr.service.internal.TransactionInternalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProducerService
implements ProducerService {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultProducerService.class);
    private TopicInternalService topicInternalService;
    private PartitionGroupInternalService partitionGroupInternalService;
    private BrokerInternalService brokerInternalService;
    private ProducerInternalService producerInternalService;
    private TransactionInternalService transactionInternalService;
    private NameServiceConfig config;
    private Messenger messenger;

    public DefaultProducerService(TopicInternalService topicInternalService, PartitionGroupInternalService partitionGroupInternalService, BrokerInternalService brokerInternalService, ProducerInternalService producerInternalService, TransactionInternalService transactionInternalService, NameServiceConfig config, Messenger messenger) {
        this.topicInternalService = topicInternalService;
        this.partitionGroupInternalService = partitionGroupInternalService;
        this.brokerInternalService = brokerInternalService;
        this.producerInternalService = producerInternalService;
        this.transactionInternalService = transactionInternalService;
        this.config = config;
        this.messenger = messenger;
    }

    @Override
    public Producer getById(String id) {
        return this.producerInternalService.getById(id);
    }

    @Override
    public Producer getByTopicAndApp(TopicName topic, String app) {
        return this.producerInternalService.getByTopicAndApp(topic, app);
    }

    @Override
    public List<Producer> getByTopic(TopicName topic) {
        return this.producerInternalService.getByTopic(topic);
    }

    @Override
    public List<Producer> getByApp(String app) {
        return this.producerInternalService.getByApp(app);
    }

    @Override
    public List<Producer> getAll() {
        return this.producerInternalService.getAll();
    }

    @Override
    public Producer add(Producer producer) {
        if (this.topicInternalService.getTopicByCode(producer.getTopic().getNamespace(), producer.getTopic().getCode()) == null) {
            throw new NsrException(String.format("topic: %s is not exist", producer.getTopic()));
        }
        if (this.producerInternalService.getByTopicAndApp(producer.getTopic(), producer.getApp()) != null) {
            throw new NsrException(String.format("producer: %s,%s is not exist", producer.getTopic(), producer.getApp()));
        }
        logger.info("addProducer, topic: {}, app: {}", (Object)producer.getTopic(), (Object)producer.getApp());
        List<PartitionGroup> partitionGroups = this.partitionGroupInternalService.getByTopic(producer.getTopic());
        List<Broker> replicas = this.getReplicas(partitionGroups);
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, app: {}", new Object[]{producer.getTopic(), producer.getApp(), e});
            throw new NsrException(e);
        }
        try {
            this.producerInternalService.add(producer);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("addProducer exception, topic: {}, app: {}", new Object[]{producer.getTopic(), producer.getApp(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishSubscriptionEnable()) {
            this.messenger.publish(new AddProducerEvent(producer.getTopic(), producer), replicas);
        }
        return producer;
    }

    @Override
    public Producer update(Producer producer) {
        Producer oldProducer = this.producerInternalService.getByTopicAndApp(producer.getTopic(), producer.getApp());
        if (oldProducer == null) {
            throw new NsrException(String.format("topic: %s, producer: %s is not exist", producer.getTopic(), producer.getApp()));
        }
        logger.info("updateProducer, topic: {}, app: {}", (Object)producer.getTopic(), (Object)producer.getApp());
        List<PartitionGroup> partitionGroups = this.partitionGroupInternalService.getByTopic(producer.getTopic());
        List<Broker> replicas = this.getReplicas(partitionGroups);
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, app: {}", new Object[]{producer.getTopic(), producer.getApp(), e});
            throw new NsrException(e);
        }
        try {
            this.producerInternalService.update(producer);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("updateProducer exception, topic: {}, app: {}", new Object[]{producer.getTopic(), producer.getApp(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishSubscriptionEnable()) {
            this.messenger.publish(new UpdateProducerEvent(producer.getTopic(), oldProducer, producer), replicas);
        }
        return producer;
    }

    @Override
    public void delete(String id) {
        Producer producer = this.producerInternalService.getById(id);
        if (producer == null) {
            throw new NsrException(String.format("producer: %s is not exist", id));
        }
        logger.info("deleteProducer, topic: {}, app: {}", (Object)producer.getTopic(), (Object)producer.getApp());
        List<PartitionGroup> partitionGroups = this.partitionGroupInternalService.getByTopic(producer.getTopic());
        List<Broker> replicas = this.getReplicas(partitionGroups);
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, app: {}", new Object[]{producer.getTopic(), producer.getApp(), e});
            throw new NsrException(e);
        }
        try {
            this.producerInternalService.delete(id);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("deleteProducer exception, topic: {}, app: {}", new Object[]{producer.getTopic(), producer.getApp(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishSubscriptionEnable()) {
            this.messenger.publish(new RemoveProducerEvent(producer.getTopic(), producer), replicas);
        }
    }

    protected List<Broker> getReplicas(List<PartitionGroup> partitionGroups) {
        if (CollectionUtils.isEmpty(partitionGroups)) {
            return null;
        }
        HashSet replicaIds = Sets.newHashSet();
        for (PartitionGroup partitionGroup : partitionGroups) {
            if (partitionGroup.getReplicas() != null) {
                replicaIds.addAll(partitionGroup.getReplicas());
            }
            if (partitionGroup.getLearners() == null) continue;
            replicaIds.addAll(partitionGroup.getLearners());
        }
        return this.brokerInternalService.getByIds(Lists.newArrayList((Iterable)replicaIds));
    }
}

