/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.support;

import com.google.common.base.Preconditions;
import com.jd.laf.extension.ExtensionPoint;
import com.jd.laf.extension.ExtensionPointLazy;
import org.joyqueue.nsr.InternalServiceProvider;
import org.joyqueue.nsr.ServiceProvider;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.message.Messenger;
import org.joyqueue.nsr.service.AppTokenService;
import org.joyqueue.nsr.service.BrokerService;
import org.joyqueue.nsr.service.ConfigService;
import org.joyqueue.nsr.service.ConsumerService;
import org.joyqueue.nsr.service.DataCenterService;
import org.joyqueue.nsr.service.NamespaceService;
import org.joyqueue.nsr.service.PartitionGroupReplicaService;
import org.joyqueue.nsr.service.PartitionGroupService;
import org.joyqueue.nsr.service.ProducerService;
import org.joyqueue.nsr.service.TopicService;
import org.joyqueue.nsr.service.internal.AppTokenInternalService;
import org.joyqueue.nsr.service.internal.BrokerInternalService;
import org.joyqueue.nsr.service.internal.ConfigInternalService;
import org.joyqueue.nsr.service.internal.ConsumerInternalService;
import org.joyqueue.nsr.service.internal.DataCenterInternalService;
import org.joyqueue.nsr.service.internal.NamespaceInternalService;
import org.joyqueue.nsr.service.internal.PartitionGroupInternalService;
import org.joyqueue.nsr.service.internal.PartitionGroupReplicaInternalService;
import org.joyqueue.nsr.service.internal.ProducerInternalService;
import org.joyqueue.nsr.service.internal.TopicInternalService;
import org.joyqueue.nsr.service.internal.TransactionInternalService;
import org.joyqueue.nsr.support.DefaultAppTokenService;
import org.joyqueue.nsr.support.DefaultBrokerService;
import org.joyqueue.nsr.support.DefaultConfigService;
import org.joyqueue.nsr.support.DefaultConsumerService;
import org.joyqueue.nsr.support.DefaultDataCenterService;
import org.joyqueue.nsr.support.DefaultNamespaceService;
import org.joyqueue.nsr.support.DefaultPartitionGroupReplicaService;
import org.joyqueue.nsr.support.DefaultPartitionGroupService;
import org.joyqueue.nsr.support.DefaultProducerService;
import org.joyqueue.nsr.support.DefaultTopicService;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;

public class DefaultServiceProvider
extends Service
implements ServiceProvider,
PropertySupplierAware {
    private ExtensionPoint<InternalServiceProvider, String> INTERNAL_SERVICE_PROVIDER_POINT = new ExtensionPointLazy(InternalServiceProvider.class);
    private ExtensionPoint<Messenger, String> MESSENGER_POINT = new ExtensionPointLazy(Messenger.class);
    private InternalServiceProvider internalServiceProvider;
    private PropertySupplier supplier;
    private AppTokenService appTokenService;
    private BrokerService brokerService;
    private ConfigService configService;
    private ConsumerService consumerService;
    private DataCenterService dataCenterService;
    private NamespaceService namespaceService;
    private PartitionGroupService partitionGroupService;
    private PartitionGroupReplicaService partitionGroupReplicaService;
    private ProducerService producerService;
    private TopicService topicService;
    private NameServiceConfig config;
    private Messenger messenger;

    public void setSupplier(PropertySupplier supplier) {
        this.supplier = supplier;
        this.config = new NameServiceConfig(supplier);
    }

    protected void validate() throws Exception {
        this.internalServiceProvider = (InternalServiceProvider)this.INTERNAL_SERVICE_PROVIDER_POINT.get();
        this.messenger = (Messenger)this.MESSENGER_POINT.get();
        Preconditions.checkArgument((this.internalServiceProvider != null ? 1 : 0) != 0, (Object)"service provider can not be null.");
        Preconditions.checkArgument((this.messenger != null ? 1 : 0) != 0, (Object)"messenger can not be null.");
    }

    protected void doStart() throws Exception {
        this.enrichIfNecessary(this.internalServiceProvider);
        this.enrichIfNecessary(this.messenger);
        this.appTokenService = new DefaultAppTokenService(this.internalServiceProvider.getService(AppTokenInternalService.class));
        this.brokerService = new DefaultBrokerService(this.internalServiceProvider.getService(BrokerInternalService.class), this.internalServiceProvider.getService(TransactionInternalService.class), this.config, this.messenger);
        this.configService = new DefaultConfigService(this.internalServiceProvider.getService(ConfigInternalService.class));
        this.consumerService = new DefaultConsumerService(this.internalServiceProvider.getService(TopicInternalService.class), this.internalServiceProvider.getService(PartitionGroupInternalService.class), this.internalServiceProvider.getService(BrokerInternalService.class), this.internalServiceProvider.getService(ConsumerInternalService.class), this.internalServiceProvider.getService(TransactionInternalService.class), this.config, this.messenger);
        this.dataCenterService = new DefaultDataCenterService(this.internalServiceProvider.getService(DataCenterInternalService.class));
        this.namespaceService = new DefaultNamespaceService(this.internalServiceProvider.getService(NamespaceInternalService.class));
        this.partitionGroupService = new DefaultPartitionGroupService(this.internalServiceProvider.getService(PartitionGroupInternalService.class));
        this.partitionGroupReplicaService = new DefaultPartitionGroupReplicaService(this.internalServiceProvider.getService(PartitionGroupReplicaInternalService.class));
        this.producerService = new DefaultProducerService(this.internalServiceProvider.getService(TopicInternalService.class), this.internalServiceProvider.getService(PartitionGroupInternalService.class), this.internalServiceProvider.getService(BrokerInternalService.class), this.internalServiceProvider.getService(ProducerInternalService.class), this.internalServiceProvider.getService(TransactionInternalService.class), this.config, this.messenger);
        this.topicService = new DefaultTopicService(this.config, this.messenger, this.internalServiceProvider.getService(TopicInternalService.class), this.internalServiceProvider.getService(PartitionGroupInternalService.class), this.internalServiceProvider.getService(BrokerInternalService.class), this.internalServiceProvider.getService(TransactionInternalService.class));
    }

    protected <T> T enrichIfNecessary(T obj) throws Exception {
        if (obj instanceof LifeCycle && ((LifeCycle)obj).isStarted()) {
            return obj;
        }
        if (obj instanceof PropertySupplierAware) {
            ((PropertySupplierAware)obj).setSupplier(this.supplier);
        }
        if (obj instanceof LifeCycle) {
            ((LifeCycle)obj).start();
        }
        return obj;
    }

    @Override
    public <T> T getService(Class<T> service) {
        if (service.equals(AppTokenService.class)) {
            return (T)this.appTokenService;
        }
        if (service.equals(BrokerService.class)) {
            return (T)this.brokerService;
        }
        if (service.equals(ConfigService.class)) {
            return (T)this.configService;
        }
        if (service.equals(ConsumerService.class)) {
            return (T)this.consumerService;
        }
        if (service.equals(DataCenterService.class)) {
            return (T)this.dataCenterService;
        }
        if (service.equals(NamespaceService.class)) {
            return (T)this.namespaceService;
        }
        if (service.equals(PartitionGroupService.class)) {
            return (T)this.partitionGroupService;
        }
        if (service.equals(PartitionGroupReplicaService.class)) {
            return (T)this.partitionGroupReplicaService;
        }
        if (service.equals(ProducerService.class)) {
            return (T)this.producerService;
        }
        if (service.equals(TopicService.class)) {
            return (T)this.topicService;
        }
        if (service.equals(Messenger.class)) {
            return (T)this.messenger;
        }
        throw new UnsupportedOperationException(service.getName());
    }
}

