/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.support;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Topic;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.nsr.config.NameServiceConfig;
import org.joyqueue.nsr.event.AddPartitionGroupEvent;
import org.joyqueue.nsr.event.AddTopicEvent;
import org.joyqueue.nsr.event.LeaderChangeEvent;
import org.joyqueue.nsr.event.RemovePartitionGroupEvent;
import org.joyqueue.nsr.event.RemoveTopicEvent;
import org.joyqueue.nsr.event.UpdatePartitionGroupEvent;
import org.joyqueue.nsr.event.UpdateTopicEvent;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.message.Messenger;
import org.joyqueue.nsr.model.TopicQuery;
import org.joyqueue.nsr.service.TopicService;
import org.joyqueue.nsr.service.internal.BrokerInternalService;
import org.joyqueue.nsr.service.internal.PartitionGroupInternalService;
import org.joyqueue.nsr.service.internal.TopicInternalService;
import org.joyqueue.nsr.service.internal.TransactionInternalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTopicService
implements TopicService {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultTopicService.class);
    private NameServiceConfig config;
    private Messenger messenger;
    private TopicInternalService topicInternalService;
    private PartitionGroupInternalService partitionGroupInternalService;
    private BrokerInternalService brokerInternalService;
    private TransactionInternalService transactionInternalService;

    public DefaultTopicService(NameServiceConfig config, Messenger messenger, TopicInternalService topicInternalService, PartitionGroupInternalService partitionGroupInternalService, BrokerInternalService brokerInternalService, TransactionInternalService transactionInternalService) {
        this.config = config;
        this.messenger = messenger;
        this.topicInternalService = topicInternalService;
        this.partitionGroupInternalService = partitionGroupInternalService;
        this.brokerInternalService = brokerInternalService;
        this.transactionInternalService = transactionInternalService;
    }

    @Override
    public Topic getById(String id) {
        return this.topicInternalService.getById(id);
    }

    @Override
    public Topic getTopicByCode(String namespace, String topic) {
        return this.topicInternalService.getTopicByCode(namespace, topic);
    }

    @Override
    public PageResult<Topic> search(QPageQuery<TopicQuery> pageQuery) {
        return this.topicInternalService.search(pageQuery);
    }

    @Override
    public PageResult<Topic> findUnsubscribedByQuery(QPageQuery<TopicQuery> pageQuery) {
        return this.topicInternalService.findUnsubscribedByQuery(pageQuery);
    }

    @Override
    public List<Topic> getAll() {
        return this.topicInternalService.getAll();
    }

    @Override
    public void addTopic(Topic topic, List<PartitionGroup> partitionGroups) {
        if (this.topicInternalService.getTopicByCode(topic.getName().getNamespace(), topic.getName().getCode()) != null) {
            throw new NsrException(String.format("topic: %s is already exist", topic.getName()));
        }
        logger.info("addTopic, topic: {}, partitionGroups: {}", (Object)topic.getName(), partitionGroups);
        this.fillBroker(partitionGroups);
        List<Broker> replicas = this.getReplicas(partitionGroups);
        for (PartitionGroup partitionGroup : partitionGroups) {
            if (!PartitionGroup.ElectType.fix.equals((Object)partitionGroup.getElectType())) continue;
            partitionGroup.setLeader((Integer)partitionGroup.getReplicas().iterator().next());
        }
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, partitionGroups: {}", new Object[]{topic, partitionGroups, e});
            throw new NsrException(e);
        }
        try {
            this.topicInternalService.addTopic(topic, partitionGroups);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("addTopic exception, topic: {}, partitionGroups: {}", new Object[]{topic, partitionGroups, e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishTopicEnable()) {
            this.messenger.publish(new AddTopicEvent(topic, partitionGroups), replicas);
        }
    }

    @Override
    public void removeTopic(Topic topic) {
        if ((topic = this.topicInternalService.getTopicByCode(topic.getName().getNamespace(), topic.getName().getCode())) == null) {
            throw new NsrException(String.format("topic: %s is not exist", topic.getName()));
        }
        logger.info("removeTopic, topic: {}", (Object)topic);
        List<PartitionGroup> partitionGroups = this.partitionGroupInternalService.getByTopic(topic.getName());
        this.fillBroker(partitionGroups);
        List<Broker> replicas = this.getReplicas(partitionGroups);
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}", (Object)topic, (Object)e);
            throw new NsrException(e);
        }
        try {
            this.topicInternalService.removeTopic(topic);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("removeTopic exception, topic: {}, partitionGroups: {}", new Object[]{topic, partitionGroups, e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishTopicEnable()) {
            this.messenger.publish(new RemoveTopicEvent(topic, partitionGroups), replicas);
        }
    }

    @Override
    public void addPartitionGroup(PartitionGroup partitionGroup) {
        if (this.topicInternalService.getTopicByCode(partitionGroup.getTopic().getNamespace(), partitionGroup.getTopic().getCode()) == null) {
            throw new NsrException(String.format("topic: %s is not exist", partitionGroup.getTopic()));
        }
        if (this.partitionGroupInternalService.getByTopicAndGroup(partitionGroup.getTopic(), partitionGroup.getGroup()) != null) {
            throw new NsrException(String.format("topic: %s, group: %s is not exist", partitionGroup.getTopic(), partitionGroup.getGroup()));
        }
        logger.info("addPartitionGroup, topic: {}, partitionGroup: {}", (Object)partitionGroup.getTopic(), (Object)partitionGroup);
        this.fillBroker(partitionGroup);
        List<Broker> replicas = this.getReplicas(partitionGroup);
        if (PartitionGroup.ElectType.fix.equals((Object)partitionGroup.getElectType())) {
            partitionGroup.setLeader((Integer)partitionGroup.getReplicas().iterator().next());
        }
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, partitionGroup: {}", new Object[]{partitionGroup.getTopic(), partitionGroup, e});
            throw new NsrException(e);
        }
        try {
            this.topicInternalService.addPartitionGroup(partitionGroup);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("addPartitionGroup exception, topic: {}, partitionGroup: {}", new Object[]{partitionGroup.getTopic(), partitionGroup.getGroup(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishTopicEnable()) {
            this.messenger.publish(new AddPartitionGroupEvent(partitionGroup.getTopic(), partitionGroup), replicas);
        }
    }

    @Override
    public void removePartitionGroup(PartitionGroup partitionGroup) {
        if (this.topicInternalService.getTopicByCode(partitionGroup.getTopic().getNamespace(), partitionGroup.getTopic().getCode()) == null) {
            throw new NsrException(String.format("topic: %s is not exist", partitionGroup.getTopic()));
        }
        PartitionGroup oldPartitionGroup = this.partitionGroupInternalService.getByTopicAndGroup(partitionGroup.getTopic(), partitionGroup.getGroup());
        if (oldPartitionGroup == null) {
            throw new NsrException(String.format("topic: %s, group: %s is not exist", partitionGroup.getTopic(), partitionGroup.getGroup()));
        }
        logger.info("removePartitionGroup, topic: {}, partitionGroup: {}", (Object)partitionGroup.getTopic(), (Object)partitionGroup);
        this.fillBroker(oldPartitionGroup);
        List<Broker> replicas = this.getReplicas(oldPartitionGroup);
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, partitionGroup: {}", new Object[]{partitionGroup.getTopic(), partitionGroup, e});
            throw new NsrException(e);
        }
        try {
            this.topicInternalService.removePartitionGroup(partitionGroup);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("removePartitionGroup exception, topic: {}, partitionGroup: {}", new Object[]{partitionGroup.getTopic(), partitionGroup.getGroup(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishTopicEnable()) {
            this.messenger.publish(new RemovePartitionGroupEvent(partitionGroup.getTopic(), oldPartitionGroup), replicas);
        }
    }

    @Override
    public Collection<Integer> updatePartitionGroup(PartitionGroup partitionGroup) {
        Topic oldTopic = this.topicInternalService.getTopicByCode(partitionGroup.getTopic().getNamespace(), partitionGroup.getTopic().getCode());
        if (oldTopic == null) {
            throw new NsrException(String.format("topic: %s is not exist", partitionGroup.getTopic()));
        }
        PartitionGroup oldPartitionGroup = this.partitionGroupInternalService.getByTopicAndGroup(partitionGroup.getTopic(), partitionGroup.getGroup());
        if (oldPartitionGroup == null) {
            throw new NsrException(String.format("topic: %s, group: %s is exist", partitionGroup.getTopic(), partitionGroup.getGroup()));
        }
        logger.info("updatePartitionGroup, topic: {}, partitionGroup: {}", (Object)partitionGroup.getTopic(), (Object)partitionGroup);
        this.fillBroker(partitionGroup);
        this.fillBroker(oldPartitionGroup);
        List<Broker> oldReplicas = this.getReplicas(oldPartitionGroup);
        List<Broker> newReplicas = this.getReplicas(partitionGroup);
        HashSet replicas = Sets.newHashSet();
        replicas.addAll(oldReplicas);
        replicas.addAll(newReplicas);
        partitionGroup.setLeader(oldPartitionGroup.getLeader());
        partitionGroup.setIsrs(oldPartitionGroup.getIsrs());
        partitionGroup.setTerm(oldPartitionGroup.getTerm());
        if (CollectionUtils.isEmpty((Collection)partitionGroup.getReplicas())) {
            partitionGroup.setLeader(Integer.valueOf(-1));
            partitionGroup.setTerm(Integer.valueOf(0));
        }
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, partitionGroup: {}", new Object[]{partitionGroup.getTopic(), partitionGroup, e});
            throw new NsrException(e);
        }
        try {
            this.topicInternalService.updatePartitionGroup(partitionGroup);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("updatePartitionGroup exception, topic: {}, partitionGroup: {}", new Object[]{partitionGroup.getTopic(), partitionGroup.getGroup(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishTopicEnable()) {
            this.messenger.publish(new UpdatePartitionGroupEvent(partitionGroup.getTopic(), oldPartitionGroup, partitionGroup), Lists.newArrayList((Iterable)replicas));
        }
        return Collections.emptyList();
    }

    @Override
    public void leaderReport(PartitionGroup group) {
        PartitionGroup oldPartitionGroup = this.partitionGroupInternalService.getById(group.getId());
        if (oldPartitionGroup == null) {
            throw new NsrException(String.format("topic: %s, group: %s is not exist", oldPartitionGroup.getTopic(), oldPartitionGroup.getGroup()));
        }
        if (oldPartitionGroup.getLeader().equals(group.getLeader()) && oldPartitionGroup.getTerm().equals(group.getTerm())) {
            return;
        }
        PartitionGroup newPartitionGroup = oldPartitionGroup.clone();
        newPartitionGroup.setIsrs(group.getIsrs());
        newPartitionGroup.setLeader(group.getLeader());
        newPartitionGroup.setTerm(group.getTerm());
        this.fillBroker(newPartitionGroup);
        List<Broker> replicas = this.getReplicas(newPartitionGroup);
        logger.info("leader report, topic: {}, partitionGroup: {}", (Object)group.getTopic(), (Object)group.getGroup());
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, partitionGroup: {}", new Object[]{group.getTopic(), group, e});
            throw new NsrException(e);
        }
        try {
            this.topicInternalService.leaderReport(newPartitionGroup);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("leader report exception, topic: {}, partitionGroup: {}", new Object[]{newPartitionGroup.getTopic(), newPartitionGroup.getGroup(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishLeaderReportEnable()) {
            this.messenger.publish(new UpdatePartitionGroupEvent(oldPartitionGroup.getTopic(), oldPartitionGroup, newPartitionGroup), replicas);
        }
    }

    @Override
    public void leaderChange(PartitionGroup group) {
        if (this.topicInternalService.getTopicByCode(group.getTopic().getNamespace(), group.getTopic().getCode()) == null) {
            throw new NsrException(String.format("topic: %s is not exist", group.getTopic()));
        }
        PartitionGroup oldPartitionGroup = this.partitionGroupInternalService.getByTopicAndGroup(group.getTopic(), group.getGroup());
        if (oldPartitionGroup == null) {
            throw new NsrException(String.format("topic: %s, group: %s is not exist", group.getTopic(), group.getGroup()));
        }
        Broker leader = this.brokerInternalService.getById(group.getLeader());
        if (leader == null) {
            throw new NsrException(String.format("topic: %s, group: %s, broker: {} is not exist", group.getTopic(), group.getGroup(), group.getLeader()));
        }
        logger.info("leaderChange, topic: {}, partitionGroup: {}", (Object)group.getTopic(), (Object)group);
        Broker oldLeader = this.brokerInternalService.getById(oldPartitionGroup.getLeader());
        if (oldLeader == null) {
            throw new NsrException(String.format("topic: %s, group: %s, broker: {} is not exist", group.getTopic(), group.getGroup(), group.getLeader()));
        }
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}, partitionGroup: {}", new Object[]{group.getTopic(), group, e});
            throw new NsrException(e);
        }
        try {
            this.topicInternalService.leaderChange(group);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("leaderChange exception, topic: {}, partitionGroup: {}", new Object[]{group.getTopic(), group.getGroup(), e});
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishLeaderChangeEnable()) {
            this.messenger.publish(new LeaderChangeEvent(group.getTopic(), oldPartitionGroup, group), oldLeader);
        }
    }

    @Override
    public List<PartitionGroup> getPartitionGroup(String namespace, String topic, Object[] groups) {
        return this.topicInternalService.getPartitionGroup(namespace, topic, groups);
    }

    @Override
    public Topic update(Topic topic) {
        Topic oldTopic = this.topicInternalService.getTopicByCode(topic.getName().getNamespace(), topic.getName().getCode());
        if (oldTopic == null) {
            throw new NsrException(String.format("topic: %s is not exist", topic.getName()));
        }
        logger.info("update, topic: {}", (Object)topic);
        List<PartitionGroup> partitionGroups = this.partitionGroupInternalService.getByTopic(topic.getName());
        List<Broker> replicas = this.getReplicas(partitionGroups);
        try {
            this.transactionInternalService.begin();
        }
        catch (Exception e) {
            logger.error("beginTransaction exception, topic: {}", (Object)topic, (Object)e);
            throw new NsrException(e);
        }
        try {
            this.topicInternalService.update(topic);
            this.transactionInternalService.commit();
        }
        catch (Exception e) {
            logger.error("removeTopic exception, topic: {}, partitionGroups: {}", new Object[]{topic, partitionGroups, e});
            if (this.config.getMessengerPublishTopicEnable()) {
                this.messenger.publish(new UpdateTopicEvent(topic, oldTopic), replicas);
            }
            this.transactionInternalService.rollback();
            throw new NsrException(e);
        }
        if (this.config.getMessengerPublishTopicEnable()) {
            this.messenger.publish(new UpdateTopicEvent(oldTopic, topic), replicas);
        }
        return topic;
    }

    protected void fillBroker(PartitionGroup partitionGroup) {
        this.fillBroker(Lists.newArrayList((Object[])new PartitionGroup[]{partitionGroup}));
    }

    protected void fillBroker(List<PartitionGroup> partitionGroups) {
        if (CollectionUtils.isEmpty(partitionGroups)) {
            return;
        }
        HashSet replicaIds = Sets.newHashSet();
        for (PartitionGroup partitionGroup : partitionGroups) {
            if (partitionGroup.getReplicas() != null) {
                replicaIds.addAll(partitionGroup.getReplicas());
            }
            if (partitionGroup.getLearners() == null) continue;
            replicaIds.addAll(partitionGroup.getLearners());
        }
        List<Broker> brokers = this.brokerInternalService.getByIds(Lists.newArrayList((Iterable)replicaIds));
        HashMap brokersMap = Maps.newHashMap();
        for (Broker broker : brokers) {
            brokersMap.put(broker.getId(), broker);
        }
        for (PartitionGroup partitionGroup : partitionGroups) {
            Broker broker;
            HashMap brokerMap = Maps.newHashMap();
            if (partitionGroup.getReplicas() != null) {
                for (Integer replica : partitionGroup.getReplicas()) {
                    broker = (Broker)brokersMap.get(replica);
                    if (broker == null) {
                        throw new NsrException(String.format("broker %d not exist", replica));
                    }
                    brokerMap.put(replica, broker);
                }
            }
            if (partitionGroup.getLearners() != null) {
                for (Integer learner : partitionGroup.getLearners()) {
                    broker = (Broker)brokersMap.get(learner);
                    if (broker == null) {
                        throw new NsrException(String.format("broker %d not exist", learner));
                    }
                    brokerMap.put(learner, broker);
                }
            }
            partitionGroup.setBrokers((Map)brokerMap);
        }
    }

    protected List<Broker> getReplicas(PartitionGroup partitionGroup) {
        return Lists.newArrayList(partitionGroup.getBrokers().values());
    }

    protected List<Broker> getReplicas(List<PartitionGroup> partitionGroups) {
        HashSet result = Sets.newHashSet();
        for (PartitionGroup partitionGroup : partitionGroups) {
            result.addAll(partitionGroup.getBrokers().values());
        }
        return Lists.newArrayList((Iterable)result);
    }
}

