/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.util;

import java.util.ArrayList;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.nsr.NsrPlugins;
import org.joyqueue.nsr.util.DCMatcher;
import org.joyqueue.toolkit.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(DCWrapper.class);
    public static String DC_URL_SEPARATOR = ";";
    public static String DC_TYPE_SEPARATOR = ":";
    private DataCenter dataCenter;
    private DCMatcher[] matchers;

    public boolean match(String ip) {
        boolean match = false;
        if (this.matchers != null) {
            DCMatcher matcher;
            DCMatcher[] dCMatcherArray = this.matchers;
            int n = dCMatcherArray.length;
            for (int i = 0; i < n && !(match = (matcher = dCMatcherArray[i]).match(ip)); ++i) {
            }
        }
        return match;
    }

    public DataCenter getDataCenter() {
        return this.dataCenter;
    }

    public DCWrapper(DataCenter dataCenter) {
        this.dataCenter = dataCenter;
        this.matchers = this.buildDCMatcher(dataCenter.getUrl());
    }

    protected DCMatcher[] buildDCMatcher(String urls) {
        ArrayList dcMatchers = new ArrayList();
        for (String uri : urls.split(DC_URL_SEPARATOR)) {
            URL url = URL.valueOf((String)uri);
            String type = uri.split(DC_TYPE_SEPARATOR)[0];
            NsrPlugins.DCMatchersPlugins.metas((Object)type).forEach(matcher -> {
                DCMatcher dcMatcher = null;
                try {
                    dcMatcher = (DCMatcher)((DCMatcher)matcher.getTarget()).getClass().newInstance();
                }
                catch (Exception e) {
                    LOG.info("New DC matcher instance exception {}", ((DCMatcher)matcher.getTarget()).getClass(), (Object)e);
                }
                if (dcMatcher != null) {
                    dcMatcher.setUrl(url);
                    dcMatchers.add(dcMatcher);
                }
            });
        }
        return dcMatchers.toArray(new DCMatcher[dcMatchers.size()]);
    }

    public static void main(String[] args) throws Exception {
        DCWrapper dcWrapper = new DCWrapper(new DataCenter("aa", "bb", "cc", "IPRANGE://?pattern=127.0.0.1-127.0.0.2"));
        System.out.println(dcWrapper);
    }
}

