/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joyqueue.nsr.util.DCMatcher;
import org.joyqueue.toolkit.URL;
import org.joyqueue.toolkit.network.IpUtil;

public class IPRangeMatcher
implements DCMatcher {
    private static Pattern P_RANGE1 = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})$");
    private static Pattern P_RANGE2 = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\-([0-9]{1,3})$");
    private static Pattern P_RANGE3 = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\-([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})\\.([0-9]{1,3})$");
    private static Pattern P_RANGE4 = Pattern.compile("^([0-9]{1,3})\\.([0-9]{1,3})\\.\\*$");
    private String pattern;

    @Override
    public boolean match(String ip) {
        String[] patts;
        if (ip == null || !IpUtil.isValidIpV4Address((String)ip)) {
            return false;
        }
        String[] parts = ip.split("[\\.]");
        for (String patt : patts = this.pattern.split("[;,]")) {
            long endIp;
            long beginIp;
            if ((patt = patt.trim()).isEmpty()) continue;
            Matcher matcher = P_RANGE3.matcher(patt);
            if (matcher.find()) {
                beginIp = IPRangeMatcher.toLong(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
                endIp = IPRangeMatcher.toLong(matcher.group(5), matcher.group(6), matcher.group(7), matcher.group(8));
            } else {
                matcher = P_RANGE1.matcher(patt);
                if (matcher.find()) {
                    beginIp = IPRangeMatcher.toLong(matcher.group(1), matcher.group(2), matcher.group(3), "0");
                    endIp = IPRangeMatcher.toLong(matcher.group(1), matcher.group(2), matcher.group(3), "255");
                } else {
                    matcher = P_RANGE2.matcher(patt);
                    if (matcher.find()) {
                        beginIp = IPRangeMatcher.toLong(matcher.group(1), matcher.group(2), matcher.group(3), "0");
                        endIp = IPRangeMatcher.toLong(matcher.group(1), matcher.group(2), matcher.group(4), "255");
                    } else {
                        matcher = P_RANGE4.matcher(patt);
                        if (!matcher.find()) continue;
                        beginIp = IPRangeMatcher.toLong(matcher.group(1), matcher.group(2), "0", "0");
                        endIp = IPRangeMatcher.toLong(matcher.group(1), matcher.group(2), "255", "255");
                    }
                }
            }
            long value = IPRangeMatcher.toLong(parts[0], parts[1], parts[2], parts[3]);
            if (value < beginIp || value > endIp) continue;
            return true;
        }
        return false;
    }

    private static long toLong(String p1, String p2, String p3, String p4) {
        long[] ip = new long[]{Long.parseLong(p1), Long.parseLong(p2), Long.parseLong(p3), Long.parseLong(p4)};
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public String type() {
        return "IPRANGE";
    }

    @Override
    public void setUrl(URL url) {
        this.pattern = (String)url.getParameters().get("pattern");
    }
}

