/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.converter;

import org.apache.commons.lang3.StringUtils;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.network.domain.BrokerNode;

public class BrokerNodeConverter {
    public static BrokerNode convertBrokerNode(Broker broker) {
        return BrokerNodeConverter.convertBrokerNode(broker, null, null);
    }

    public static BrokerNode convertBrokerNode(Broker broker, DataCenter brokerDataCenter, String region) {
        return BrokerNodeConverter.convertBrokerNode(broker, brokerDataCenter, region, 0);
    }

    public static BrokerNode convertBrokerNode(Broker broker, DataCenter brokerDataCenter, String region, int weight) {
        BrokerNode result = new BrokerNode();
        result.setId(broker.getId().intValue());
        result.setHost(broker.getIp());
        result.setPort(broker.getPort());
        result.setDataCenter(brokerDataCenter == null ? null : brokerDataCenter.getRegion());
        if (StringUtils.isBlank((CharSequence)region) || brokerDataCenter == null) {
            result.setNearby(true);
        } else {
            result.setNearby(StringUtils.equalsIgnoreCase((CharSequence)brokerDataCenter.getRegion(), (CharSequence)region));
        }
        result.setWeight(weight);
        if (Broker.PermissionEnum.FULL.equals((Object)broker.getPermission())) {
            result.setReadable(true);
            result.setWritable(true);
        } else if (Broker.PermissionEnum.READ.equals((Object)broker.getPermission())) {
            result.setReadable(true);
        } else if (Broker.PermissionEnum.WRITE.equals((Object)broker.getPermission())) {
            result.setWritable(true);
        }
        return result;
    }
}

