/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.coordinator.assignment;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.joyqueue.broker.protocol.config.JoyQueueConfig;
import org.joyqueue.broker.protocol.coordinator.GroupMetadataManager;
import org.joyqueue.broker.protocol.coordinator.assignment.PartitionAssignorResolver;
import org.joyqueue.broker.protocol.coordinator.assignment.delay.MemberTimeoutDelayedOperation;
import org.joyqueue.broker.protocol.coordinator.domain.GroupMemberMetadata;
import org.joyqueue.broker.protocol.coordinator.domain.GroupMetadata;
import org.joyqueue.broker.protocol.coordinator.domain.PartitionAssignment;
import org.joyqueue.broker.protocol.exception.JoyQueueException;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.toolkit.delay.DelayedOperation;
import org.joyqueue.toolkit.delay.DelayedOperationKey;
import org.joyqueue.toolkit.delay.DelayedOperationManager;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAssignmentHandler
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(PartitionAssignmentHandler.class);
    private JoyQueueConfig config;
    private GroupMetadataManager coordinatorGroupManager;
    private PartitionAssignorResolver partitionAssignorResolver;
    private DelayedOperationManager memberTimeoutDelayedOperationManager;

    public PartitionAssignmentHandler(JoyQueueConfig config, GroupMetadataManager coordinatorGroupManager) {
        this.config = config;
        this.coordinatorGroupManager = coordinatorGroupManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionAssignment assign(String topic, String app, String connectionId, String connectionHost, int sessionTimeout, List<PartitionGroup> partitionGroups) {
        GroupMetadata group = this.coordinatorGroupManager.getGroup(app);
        if (group == null) {
            group = this.coordinatorGroupManager.getOrCreateGroup(new GroupMetadata(app));
        }
        GroupMetadata groupMetadata = group;
        synchronized (groupMetadata) {
            return this.doAssign(group, topic, connectionId, connectionHost, sessionTimeout, partitionGroups);
        }
    }

    protected PartitionAssignment doAssign(GroupMetadata group, String topic, String connectionId, String connectionHost, int sessionTimeout, List<PartitionGroup> partitionGroups) {
        GroupMemberMetadata member = (GroupMemberMetadata)((Object)group.getMembers().get(connectionId));
        DelayedOperationKey memberTimeoutDelayedOperationKey = new DelayedOperationKey(new Object[]{connectionId});
        if (member == null) {
            member = new GroupMemberMetadata(connectionId, group.getId(), connectionId, connectionHost, sessionTimeout);
            group.addMember(member);
        } else {
            this.memberTimeoutDelayedOperationManager.checkAndComplete((Object)memberTimeoutDelayedOperationKey);
        }
        PartitionAssignment assignment = this.partitionAssignorResolver.assign(group, member, topic, partitionGroups);
        if (assignment == null) {
            throw new JoyQueueException(JoyQueueCode.FW_COORDINATOR_PARTITION_ASSIGNOR_ERROR.getCode());
        }
        member.setLatestHeartbeat(SystemClock.now());
        member.setAssignedTopicPartitions(topic, assignment.getPartitions());
        this.memberTimeoutDelayedOperationManager.tryCompleteElseWatch((DelayedOperation)new MemberTimeoutDelayedOperation(group, member, sessionTimeout + this.config.getCoordinatorPartitionAssignTimeoutOverflow()), (Set)Sets.newHashSet((Object[])new DelayedOperationKey[]{memberTimeoutDelayedOperationKey}));
        return assignment;
    }

    protected void validate() throws Exception {
        this.partitionAssignorResolver = new PartitionAssignorResolver(this.config);
        this.memberTimeoutDelayedOperationManager = new DelayedOperationManager("joyqueue-member-timeout-delayed");
    }

    protected void doStart() throws Exception {
        this.memberTimeoutDelayedOperationManager.start();
    }

    protected void doStop() {
        if (this.memberTimeoutDelayedOperationManager != null) {
            this.memberTimeoutDelayedOperationManager.shutdown();
        }
    }
}

