/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.coordinator.assignment;

import com.google.common.collect.Maps;
import com.jd.laf.extension.ExtensionPoint;
import com.jd.laf.extension.ExtensionPointLazy;
import com.jd.laf.extension.SpiLoader;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.protocol.config.JoyQueueConfig;
import org.joyqueue.broker.protocol.coordinator.assignment.PartitionAssignor;
import org.joyqueue.broker.protocol.coordinator.domain.GroupMemberMetadata;
import org.joyqueue.broker.protocol.coordinator.domain.GroupMetadata;
import org.joyqueue.broker.protocol.coordinator.domain.PartitionAssignment;
import org.joyqueue.broker.protocol.exception.JoyQueueException;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.exception.JoyQueueCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAssignorResolver {
    protected static final Logger logger = LoggerFactory.getLogger(PartitionAssignorResolver.class);
    private JoyQueueConfig config;
    private ExtensionPoint<PartitionAssignor, String> partitionAssignors = new ExtensionPointLazy(PartitionAssignor.class, SpiLoader.INSTANCE, null, null);

    public PartitionAssignorResolver(JoyQueueConfig config) {
        this.config = config;
    }

    public PartitionAssignment assign(GroupMetadata group, GroupMemberMetadata member, String topic, List<PartitionGroup> partitionGroups) {
        PartitionAssignor partitionAssignor;
        String assignType = this.config.getCoordinatorPartitionAssignType();
        PartitionAssignor partitionAssignor2 = partitionAssignor = StringUtils.isBlank((CharSequence)assignType) ? null : (PartitionAssignor)this.partitionAssignors.get((Object)assignType);
        if (partitionAssignor == null) {
            throw new JoyQueueException(JoyQueueCode.FW_COORDINATOR_PARTITION_ASSIGNOR_TYPE_NOT_EXIST.getMessage(new Object[]{assignType}), JoyQueueCode.FW_COORDINATOR_PARTITION_ASSIGNOR_TYPE_NOT_EXIST.getCode());
        }
        if (!StringUtils.equals((CharSequence)group.getAssignType(), (CharSequence)assignType)) {
            group.setAssignContext(Maps.newHashMap());
            group.setAssignType(assignType);
            member.setTimeoutCallback(null);
        }
        return partitionAssignor.assign(group, member, topic, partitionGroups);
    }
}

