/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.coordinator.assignment.delay;

import org.joyqueue.broker.protocol.coordinator.domain.GroupMemberMetadata;
import org.joyqueue.broker.protocol.coordinator.domain.GroupMetadata;
import org.joyqueue.toolkit.delay.AbstractDelayedOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemberTimeoutDelayedOperation
extends AbstractDelayedOperation {
    protected static final Logger logger = LoggerFactory.getLogger(MemberTimeoutDelayedOperation.class);
    private GroupMetadata group;
    private GroupMemberMetadata member;

    public MemberTimeoutDelayedOperation(GroupMetadata group, GroupMemberMetadata member, long delayMs) {
        super(delayMs);
        this.group = group;
        this.member = member;
    }

    protected boolean tryComplete() {
        if (this.member.isExpired()) {
            return this.forceComplete();
        }
        return false;
    }

    protected void onExpiration() {
        if (!this.group.getMembers().containsKey(this.member.getId()) || !this.member.isExpired()) {
            return;
        }
        logger.info("joyqueue consumer {} is expired, release assigned partition, connection: {}, latestHeartbeat: {}", new Object[]{this.member.getId(), this.member.getConnectionHost(), this.member.getLatestHeartbeat()});
        if (this.member.getTimeoutCallback() != null) {
            this.member.getTimeoutCallback().onCompletion(this.group, this.member);
        }
        this.group.addExpiredMember(this.member);
        this.group.getMembers().remove(this.member.getId(), (Object)this.member);
    }
}

