/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.coordinator.assignment.support;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.protocol.JoyQueueContext;
import org.joyqueue.broker.protocol.config.JoyQueueConfig;
import org.joyqueue.broker.protocol.coordinator.GroupMemberTimeoutCallback;
import org.joyqueue.broker.protocol.coordinator.assignment.PartitionAssignor;
import org.joyqueue.broker.protocol.coordinator.assignment.converter.PartitionAssignmentConverter;
import org.joyqueue.broker.protocol.coordinator.assignment.domain.PartitionGroupAssignmentMetadata;
import org.joyqueue.broker.protocol.coordinator.assignment.domain.TopicPartitionGroupAssignmentMetadata;
import org.joyqueue.broker.protocol.coordinator.domain.GroupMemberMetadata;
import org.joyqueue.broker.protocol.coordinator.domain.GroupMetadata;
import org.joyqueue.broker.protocol.coordinator.domain.PartitionAssignment;
import org.joyqueue.domain.PartitionGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionGroupBalancePartitionAssignor
implements PartitionAssignor {
    protected static final Logger logger = LoggerFactory.getLogger(PartitionGroupBalancePartitionAssignor.class);

    @Override
    public PartitionAssignment assign(GroupMetadata group, GroupMemberMetadata member, String topic, List<PartitionGroup> partitionGroups) {
        JoyQueueConfig config = JoyQueueContext.getConfig();
        int minConnections = config.getCoordinatorPartitionAssignMinConnections();
        TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata = this.getOrCreateTopicPartitionGroupAssignMetadata(group, topic);
        this.releaseAssigned(group, member, topic);
        List<PartitionGroup> assignedPartitionGroups = this.doAssign(group, topicPartitionGroupAssignmentMetadata, partitionGroups, minConnections);
        this.saveAssignedPartitionGroups(topicPartitionGroupAssignmentMetadata, member, topic, assignedPartitionGroups);
        if (member.getTimeoutCallback() == null) {
            member.setTimeoutCallback(new GroupMemberTimeoutCallback(){

                @Override
                public void onCompletion(GroupMetadata group, GroupMemberMetadata member) {
                    PartitionGroupBalancePartitionAssignor.this.releaseAllAssigned(group, member);
                }
            });
        }
        return this.buildPartitionAssignment(member, assignedPartitionGroups);
    }

    protected List<PartitionGroup> doAssign(GroupMetadata group, TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata, List<PartitionGroup> partitionGroups, int minConnections) {
        List<PartitionGroup> idledPartitionGroups = this.getIdledPartitionGroups(topicPartitionGroupAssignmentMetadata, partitionGroups, minConnections);
        if (CollectionUtils.isNotEmpty(idledPartitionGroups)) {
            return idledPartitionGroups;
        }
        int quota = partitionGroups.size() / group.getMembers().size();
        if (quota == 0) {
            quota = 1;
        }
        return this.getLowLoadPartitionGroups(topicPartitionGroupAssignmentMetadata, partitionGroups, quota);
    }

    protected List<PartitionGroup> getIdledPartitionGroups(TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata, List<PartitionGroup> partitionGroups, int minConnections) {
        LinkedList result = null;
        for (PartitionGroup partitionGroup : partitionGroups) {
            PartitionGroupAssignmentMetadata partitionGroupAssignmentMetadata = this.getOrCreatePartitionGroupAssignMetadata(topicPartitionGroupAssignmentMetadata, partitionGroup.getGroup());
            if (partitionGroupAssignmentMetadata.getAssigned() >= minConnections) continue;
            if (result == null) {
                result = Lists.newLinkedList();
            }
            result.add(partitionGroup);
        }
        return result;
    }

    protected List<PartitionGroup> getLowLoadPartitionGroups(final TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata, List<PartitionGroup> partitionGroups, int count) {
        partitionGroups = Lists.newArrayList(partitionGroups);
        Collections.sort(partitionGroups, new Comparator<PartitionGroup>(){

            @Override
            public int compare(PartitionGroup o1, PartitionGroup o2) {
                PartitionGroupAssignmentMetadata o1Metadata = PartitionGroupBalancePartitionAssignor.this.getOrCreatePartitionGroupAssignMetadata(topicPartitionGroupAssignmentMetadata, o1.getGroup());
                PartitionGroupAssignmentMetadata o2Metadata = PartitionGroupBalancePartitionAssignor.this.getOrCreatePartitionGroupAssignMetadata(topicPartitionGroupAssignmentMetadata, o2.getGroup());
                return Integer.compare(o1Metadata.getAssigned(), o2Metadata.getAssigned());
            }
        });
        LinkedList result = Lists.newLinkedList();
        for (int i = 0; i < count; ++i) {
            result.add(partitionGroups.get(i));
        }
        return result;
    }

    protected void saveAssignedPartitionGroups(TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata, GroupMemberMetadata member, String topic, List<PartitionGroup> assignedPartitionGroups) {
        for (PartitionGroup assignedPartitionGroup : assignedPartitionGroups) {
            this.assignPartitionGroup(member, topicPartitionGroupAssignmentMetadata, assignedPartitionGroup.getGroup());
        }
    }

    protected PartitionAssignment buildPartitionAssignment(GroupMemberMetadata member, List<PartitionGroup> assignedPartitionGroups) {
        return PartitionAssignmentConverter.convert(assignedPartitionGroups);
    }

    protected void releaseAllAssigned(GroupMetadata group, GroupMemberMetadata member) {
        for (Map.Entry entry : member.getAssignments().entrySet()) {
            this.releaseAssigned(group, member, (String)entry.getKey());
        }
    }

    protected void releaseAssigned(GroupMetadata group, GroupMemberMetadata member, String topic) {
        ArrayList assignedPartitionGroups = member.getAssignedTopicPartitionGroups(topic);
        if (CollectionUtils.isEmpty(assignedPartitionGroups)) {
            return;
        }
        TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata = this.getOrCreateTopicPartitionGroupAssignMetadata(group, topic);
        assignedPartitionGroups = Lists.newArrayList(assignedPartitionGroups);
        for (Integer assignedPartitionGroup : assignedPartitionGroups) {
            this.releasePartitionGroupAssign(member, topicPartitionGroupAssignmentMetadata, assignedPartitionGroup);
        }
    }

    protected void assignPartitionGroup(GroupMemberMetadata member, TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata, int partitionGroupId) {
        PartitionGroupAssignmentMetadata partitionGroupAssignmentMetadata = this.getOrCreatePartitionGroupAssignMetadata(topicPartitionGroupAssignmentMetadata, partitionGroupId);
        partitionGroupAssignmentMetadata.incrAssigned();
        member.addAssignedPartitionGroups(topicPartitionGroupAssignmentMetadata.getTopic(), partitionGroupId);
    }

    protected void releasePartitionGroupAssign(GroupMemberMetadata member, TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata, int partitionGroupId) {
        PartitionGroupAssignmentMetadata partitionGroupAssignmentMetadata = this.getOrCreatePartitionGroupAssignMetadata(topicPartitionGroupAssignmentMetadata, partitionGroupId);
        partitionGroupAssignmentMetadata.decrAssigned();
        member.removeAssignedPartitionGroups(topicPartitionGroupAssignmentMetadata.getTopic(), partitionGroupId);
    }

    protected PartitionGroupAssignmentMetadata getOrCreatePartitionGroupAssignMetadata(TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata, int partitionGroupId) {
        PartitionGroupAssignmentMetadata partitionGroupAssignmentMetadata = topicPartitionGroupAssignmentMetadata.getPartitionGroups().get(partitionGroupId);
        if (partitionGroupAssignmentMetadata == null) {
            partitionGroupAssignmentMetadata = new PartitionGroupAssignmentMetadata();
            partitionGroupAssignmentMetadata.setPartitionGroupId(partitionGroupId);
            topicPartitionGroupAssignmentMetadata.getPartitionGroups().put(partitionGroupId, partitionGroupAssignmentMetadata);
        }
        return partitionGroupAssignmentMetadata;
    }

    protected TopicPartitionGroupAssignmentMetadata getOrCreateTopicPartitionGroupAssignMetadata(GroupMetadata group, String topic) {
        TopicPartitionGroupAssignmentMetadata topicPartitionGroupAssignmentMetadata = (TopicPartitionGroupAssignmentMetadata)group.getAssignContext().get(topic);
        if (topicPartitionGroupAssignmentMetadata == null) {
            topicPartitionGroupAssignmentMetadata = new TopicPartitionGroupAssignmentMetadata();
            topicPartitionGroupAssignmentMetadata.setTopic(topic);
            group.getAssignContext().put(topic, topicPartitionGroupAssignmentMetadata);
        }
        return topicPartitionGroupAssignmentMetadata;
    }

    public String type() {
        return "PARTITION_GROUP_BALANCE";
    }
}

