/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.coordinator.domain;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.protocol.coordinator.GroupMemberTimeoutCallback;

public class GroupMemberMetadata
extends org.joyqueue.broker.coordinator.group.domain.GroupMemberMetadata {
    private GroupMemberTimeoutCallback timeoutCallback;
    private Map<String, List<Integer>> assignedPartitionGroups;

    public GroupMemberMetadata() {
    }

    public GroupMemberMetadata(String id, String groupId, String connectionId, String connectionHost, int sessionTimeout) {
        super(id, groupId, connectionId, connectionHost, sessionTimeout);
    }

    public void addAssignedPartitionGroups(String topic, int partitionGroupId) {
        this.getAssignedTopicPartitionGroups(topic).add(partitionGroupId);
    }

    public void removeAssignedPartitionGroups(String topic, int partitionGroupId) {
        if (this.assignedPartitionGroups == null) {
            return;
        }
        List<Integer> partitionGroups = this.assignedPartitionGroups.get(topic);
        if (partitionGroups == null) {
            return;
        }
        partitionGroups.remove((Object)partitionGroupId);
    }

    public List<Integer> getAssignedTopicPartitionGroups(String topic) {
        Map<String, List<Integer>> assignments = this.getOrCreateAssignedPartitionGroups();
        ArrayList partitionGroupList = assignments.get(topic);
        if (partitionGroupList == null) {
            partitionGroupList = Lists.newArrayList();
            assignments.put(topic, partitionGroupList);
        }
        return partitionGroupList;
    }

    protected Map<String, List<Integer>> getOrCreateAssignedPartitionGroups() {
        if (this.assignedPartitionGroups == null) {
            this.assignedPartitionGroups = Maps.newHashMap();
        }
        return this.assignedPartitionGroups;
    }

    public void setAssignedPartitionGroups(Map<String, List<Integer>> assignedPartitionGroups) {
        this.assignedPartitionGroups = assignedPartitionGroups;
    }

    public Map<String, List<Integer>> getAssignedTopicPartitionGroups() {
        return this.assignedPartitionGroups;
    }

    public void setTimeoutCallback(GroupMemberTimeoutCallback timeoutCallback) {
        this.timeoutCallback = timeoutCallback;
    }

    public GroupMemberTimeoutCallback getTimeoutCallback() {
        return this.timeoutCallback;
    }
}

