/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.message.SourceType;
import org.joyqueue.network.command.AddConnectionRequest;
import org.joyqueue.network.command.AddConnectionResponse;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.security.Authentication;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddConnectionRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(AddConnectionRequestHandler.class);
    private BrokerConfig brokerConfig;
    private Authentication authentication;
    private SessionManager sessionManager;
    private ClusterManager clusterManager;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerConfig = brokerContext.getBrokerConfig();
        this.authentication = brokerContext.getAuthentication();
        this.sessionManager = brokerContext.getSessionManager();
        this.clusterManager = brokerContext.getClusterManager();
    }

    public Command handle(Transport transport, Command command) {
        AddConnectionRequest addConnectionRequest = (AddConnectionRequest)command.getPayload();
        if (!this.authentication.auth(addConnectionRequest.getApp(), addConnectionRequest.getToken()).isSuccess()) {
            logger.warn("user auth failed, transport: {}, app: {}", (Object)transport, (Object)addConnectionRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.CN_AUTHENTICATION_ERROR.getCode(), (String)(JoyQueueCode.CN_AUTHENTICATION_ERROR.getMessage(new Object[0]) + String.format(", app: %s", addConnectionRequest.getApp())));
        }
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null && SessionHelper.putIfAbsentConnection((Transport)transport, (Connection)(connection = this.buildConnection(transport, addConnectionRequest)))) {
            this.sessionManager.addConnection(connection);
        }
        AddConnectionResponse addConnectionResponse = new AddConnectionResponse();
        addConnectionResponse.setConnectionId(connection.getId());
        return new Command((Object)addConnectionResponse);
    }

    protected Connection buildConnection(Transport transport, AddConnectionRequest addConnectionRequest) {
        Connection connection = new Connection();
        connection.setTransport(transport);
        connection.setApp(addConnectionRequest.getApp());
        connection.setId(this.generateConnectionId(transport, addConnectionRequest));
        connection.setRegion(addConnectionRequest.getRegion());
        connection.setNamespace(addConnectionRequest.getNamespace());
        connection.setLanguage(addConnectionRequest.getLanguage());
        connection.setSource(SourceType.JOYQUEUE.name());
        connection.setCreateTime(SystemClock.now());
        connection.setVersion(addConnectionRequest.getClientId().getVersion());
        connection.setAddressStr(IpUtil.toAddress((SocketAddress)transport.remoteAddress()));
        connection.setHost(((InetSocketAddress)transport.remoteAddress()).getHostString());
        connection.setAddress(IpUtil.toByte((InetSocketAddress)((InetSocketAddress)transport.remoteAddress())));
        connection.setServerAddress(this.brokerConfig.getFrontendConfig().getHost().getBytes());
        connection.setSystem(this.authentication.isAdmin(addConnectionRequest.getApp()));
        connection.setAuth(true);
        return connection;
    }

    protected String generateConnectionId(Transport transport, AddConnectionRequest addConnectionRequest) {
        InetSocketAddress inetRemoteAddress = (InetSocketAddress)transport.remoteAddress();
        return String.format("%s-%s_%s-%s-%s", addConnectionRequest.getClientId().getVersion(), inetRemoteAddress.getHostString(), inetRemoteAddress.getPort(), SystemClock.now(), addConnectionRequest.getClientId().getSequence());
    }

    public int type() {
        return JoyQueueCommandType.ADD_CONNECTION_REQUEST.getCode();
    }
}

