/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.AddConsumerRequest;
import org.joyqueue.network.command.AddConsumerResponse;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddConsumerRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(AddConsumerRequestHandler.class);
    private SessionManager sessionManager;
    private ClusterManager clusterManager;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.sessionManager = brokerContext.getSessionManager();
        this.clusterManager = brokerContext.getClusterManager();
    }

    public Command handle(Transport transport, Command command) {
        AddConsumerRequest addConsumerRequest = (AddConsumerRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(addConsumerRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}", (Object)transport);
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        HashMap result = Maps.newHashMap();
        for (String topic : addConsumerRequest.getTopics()) {
            if (connection.containsConsumer(topic, addConsumerRequest.getApp())) {
                result.put(topic, connection.getConsumer(topic, addConsumerRequest.getApp()));
                continue;
            }
            TopicName topicName = TopicName.parse((String)topic);
            if (this.clusterManager.tryGetConsumerPolicy(topicName, addConsumerRequest.getApp()) == null) {
                logger.warn("addConsumer failed, transport: {}, topic: {}, app: {}", new Object[]{transport, topicName, addConsumerRequest.getApp()});
                return BooleanAck.build((JoyQueueCode)JoyQueueCode.CN_NO_PERMISSION, (Object[])new Object[0]);
            }
            Consumer consumer = this.buildConsumer(connection, topic, addConsumerRequest.getApp(), addConsumerRequest.getSequence());
            this.sessionManager.addConsumer(consumer);
            result.put(topic, consumer.getId());
        }
        AddConsumerResponse addConsumerResponse = new AddConsumerResponse();
        addConsumerResponse.setConsumerIds((Map)result);
        return new Command((Object)addConsumerResponse);
    }

    protected Consumer buildConsumer(Connection connection, String topic, String app, long sequence) {
        Consumer consumer = new Consumer();
        consumer.setId(this.generateConsumerId(connection, topic, app, sequence));
        consumer.setConnectionId(connection.getId());
        consumer.setApp(app);
        consumer.setTopic(topic);
        consumer.setType(Consumer.ConsumeType.JOYQUEUE);
        return consumer;
    }

    protected String generateConsumerId(Connection connection, String topic, String app, long sequence) {
        return String.format("%s_%s_consumer_%s_%s", connection.getId(), sequence, app, topic);
    }

    public int type() {
        return JoyQueueCommandType.ADD_CONSUMER_REQUEST.getCode();
    }
}

