/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.AddProducerRequest;
import org.joyqueue.network.command.AddProducerResponse;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddProducerRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(AddProducerRequestHandler.class);
    private SessionManager sessionManager;
    private ClusterManager clusterManager;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.sessionManager = brokerContext.getSessionManager();
        this.clusterManager = brokerContext.getClusterManager();
    }

    public Command handle(Transport transport, Command command) {
        AddProducerRequest addProducerRequest = (AddProducerRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(addProducerRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)addProducerRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        HashMap result = Maps.newHashMap();
        for (String topic : addProducerRequest.getTopics()) {
            if (connection.containsProducer(topic, addProducerRequest.getApp())) {
                result.put(topic, connection.getProducer(topic, addProducerRequest.getApp()));
                continue;
            }
            TopicName topicName = TopicName.parse((String)topic);
            if (this.clusterManager.tryGetProducer(topicName, addProducerRequest.getApp()) == null) {
                logger.warn("addProducer failed, transport: {}, topic: {}, app: {}", new Object[]{transport, topicName, addProducerRequest.getApp()});
                return BooleanAck.build((JoyQueueCode)JoyQueueCode.CN_NO_PERMISSION, (Object[])new Object[0]);
            }
            Producer producer = this.buildProducer(connection, topic, addProducerRequest.getApp(), addProducerRequest.getSequence());
            this.sessionManager.addProducer(producer);
            result.put(topic, producer.getId());
        }
        AddProducerResponse addProducerResponse = new AddProducerResponse();
        addProducerResponse.setProducerIds((Map)result);
        return new Command((Object)addProducerResponse);
    }

    protected Producer buildProducer(Connection connection, String topic, String app, long sequence) {
        Producer producer = new Producer();
        producer.setId(this.generateProducerId(connection, topic, app, sequence));
        producer.setConnectionId(connection.getId());
        producer.setApp(app);
        producer.setTopic(topic);
        producer.setType(Producer.ProducerType.JOYQUEUE);
        return producer;
    }

    protected String generateProducerId(Connection connection, String topic, String app, long sequence) {
        return String.format("%s_%s_producer_%s_%s", connection.getId(), sequence, app, topic);
    }

    public int type() {
        return JoyQueueCommandType.ADD_PRODUCER_REQUEST.getCode();
    }
}

