/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.MessageLocation;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.CommitAckData;
import org.joyqueue.network.command.CommitAckRequest;
import org.joyqueue.network.command.CommitAckResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.RetryType;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.toolkit.lang.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitAckRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(CommitAckRequestHandler.class);
    private Consume consume;
    private MessageRetry retryManager;
    private ClusterManager clusterManager;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.consume = brokerContext.getConsume();
        this.retryManager = brokerContext.getRetryManager();
        this.clusterManager = brokerContext.getClusterManager();
    }

    public Command handle(Transport transport, Command command) {
        CommitAckRequest commitAckRequest = (CommitAckRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(commitAckRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)commitAckRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        HashBasedTable result = HashBasedTable.create();
        for (Map.Entry entry : commitAckRequest.getData().rowMap().entrySet()) {
            String topic = (String)entry.getKey();
            for (Map.Entry partitionEntry : ((Map)entry.getValue()).entrySet()) {
                JoyQueueCode ackCode = this.commitAck(connection, topic, commitAckRequest.getApp(), (Short)partitionEntry.getKey(), (List)partitionEntry.getValue());
                result.put((Object)topic, partitionEntry.getKey(), (Object)ackCode);
            }
        }
        CommitAckResponse commitAckResponse = new CommitAckResponse();
        commitAckResponse.setResult((Table)result);
        return new Command((Object)commitAckResponse);
    }

    protected JoyQueueCode commitAck(Connection connection, String topic, String app, short partition, List<CommitAckData> dataList) {
        if (partition == Short.MAX_VALUE) {
            return this.doCommitRetry(connection, topic, app, partition, dataList);
        }
        return this.doCommitAck(connection, topic, app, partition, dataList);
    }

    protected JoyQueueCode doCommitRetry(Connection connection, String topic, String app, short partition, List<CommitAckData> dataList) {
        try {
            LinkedList retrySuccess = Lists.newLinkedList();
            LinkedList retryError = Lists.newLinkedList();
            for (CommitAckData commitAckData : dataList) {
                if (commitAckData.getRetryType().equals((Object)RetryType.NONE)) {
                    retrySuccess.add(commitAckData.getIndex());
                    continue;
                }
                retryError.add(commitAckData.getIndex());
            }
            if (CollectionUtils.isNotEmpty((Collection)retrySuccess)) {
                this.retryManager.retrySuccess(topic, app, (Object[])ListUtil.toArray((List)retrySuccess));
            }
            if (CollectionUtils.isNotEmpty((Collection)retryError)) {
                this.retryManager.retryError(topic, app, (Object[])ListUtil.toArray((List)retryError));
            }
            return JoyQueueCode.SUCCESS;
        }
        catch (JoyQueueException e) {
            logger.error("commit ack exception, topic: {}, app: {}, partition: {}, transport: {}", new Object[]{topic, app, partition, connection.getTransport(), e});
            return JoyQueueCode.valueOf((int)e.getCode());
        }
        catch (Exception e) {
            logger.error("commit ack exception, topic: {}, app: {}, partition: {}, transport: {}", new Object[]{topic, app, partition, connection.getTransport(), e});
            return JoyQueueCode.CN_UNKNOWN_ERROR;
        }
    }

    protected JoyQueueCode doCommitAck(Connection connection, String topic, String app, short partition, List<CommitAckData> dataList) {
        MessageLocation[] messageLocations = new MessageLocation[dataList.size()];
        LinkedList retryDataList = null;
        Consumer consumer = new Consumer(connection.getId(), topic, app, Consumer.ConsumeType.JOYQUEUE);
        for (int i = 0; i < dataList.size(); ++i) {
            CommitAckData data = dataList.get(i);
            messageLocations[i] = new MessageLocation(topic, partition, data.getIndex());
            if (data.getRetryType().equals((Object)RetryType.NONE)) continue;
            if (retryDataList == null) {
                retryDataList = Lists.newLinkedList();
            }
            retryDataList.add(data);
        }
        try {
            if (CollectionUtils.isNotEmpty(retryDataList)) {
                try {
                    this.commitRetry(connection, consumer, retryDataList);
                }
                catch (JoyQueueException e) {
                    logger.error("commit retry exception, topic: {}, app: {}, partition: {}, transport: {}", new Object[]{topic, app, partition, connection.getTransport(), e});
                    this.consume.releasePartition(topic, app, partition);
                    return JoyQueueCode.valueOf((int)e.getCode());
                }
                catch (Exception e) {
                    logger.error("commit retry exception, topic: {}, app: {}, partition: {}, transport: {}", new Object[]{topic, app, partition, connection.getTransport(), e});
                    this.consume.releasePartition(topic, app, partition);
                    return JoyQueueCode.CN_UNKNOWN_ERROR;
                }
            }
            this.consume.acknowledge(messageLocations, consumer, connection, true);
            return JoyQueueCode.SUCCESS;
        }
        catch (JoyQueueException e) {
            logger.error("commit ack exception, topic: {}, app: {}, partition: {}, transport: {}", new Object[]{topic, app, partition, connection.getTransport(), e});
            return JoyQueueCode.valueOf((int)e.getCode());
        }
        catch (Exception e) {
            logger.error("commit ack exception, topic: {}, app: {}, partition: {}, transport: {}", new Object[]{topic, app, partition, connection.getTransport(), e});
            return JoyQueueCode.CN_UNKNOWN_ERROR;
        }
    }

    protected void commitRetry(Connection connection, Consumer consumer, List<CommitAckData> data) throws Exception {
        LinkedList retryMessageModelList = Lists.newLinkedList();
        for (CommitAckData ackData : data) {
            PullResult pullResult = this.consume.getMessage(consumer, ackData.getPartition(), ackData.getIndex(), 1);
            List buffers = pullResult.getBuffers();
            if (buffers.size() != 1) {
                logger.error("get retryMessage error, message not exist, transport: {}, topic: {}, app: {}, partition: {}, index: {}", new Object[]{connection.getTransport().remoteAddress(), consumer.getTopic(), consumer.getApp(), ackData.getPartition(), ackData.getIndex()});
                continue;
            }
            ByteBuffer buffer = (ByteBuffer)buffers.get(0);
            BrokerMessage brokerMessage = Serializer.readBrokerMessage((ByteBuffer)buffer);
            RetryMessageModel model = this.generateRetryMessage(consumer, brokerMessage, buffer.array(), ackData.getRetryType().name());
            retryMessageModelList.add(model);
        }
        this.retryManager.addRetry((List)retryMessageModelList);
    }

    private RetryMessageModel generateRetryMessage(Consumer consumer, BrokerMessage brokerMessage, byte[] brokerMessageData, String exception) {
        RetryMessageModel model = new RetryMessageModel();
        model.setBusinessId(brokerMessage.getBusinessId());
        model.setTopic(consumer.getTopic());
        model.setApp(consumer.getApp());
        model.setPartition((short)Short.MAX_VALUE);
        model.setIndex(brokerMessage.getMsgIndexNo());
        model.setBrokerMessage(brokerMessageData);
        byte[] exceptionBytes = exception.getBytes(Charset.forName("UTF-8"));
        model.setException(exceptionBytes);
        model.setSendTime(brokerMessage.getStartTime());
        return model;
    }

    public int type() {
        return JoyQueueCommandType.COMMIT_ACK_REQUEST.getCode();
    }
}

