/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.JoyQueueContext;
import org.joyqueue.broker.protocol.JoyQueueContextAware;
import org.joyqueue.broker.protocol.coordinator.Coordinator;
import org.joyqueue.broker.protocol.coordinator.assignment.PartitionAssignmentHandler;
import org.joyqueue.broker.protocol.coordinator.domain.PartitionAssignment;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.FetchAssignedPartitionAckData;
import org.joyqueue.network.command.FetchAssignedPartitionData;
import org.joyqueue.network.command.FetchAssignedPartitionRequest;
import org.joyqueue.network.command.FetchAssignedPartitionResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.NameService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchAssignedPartitionRequestHandler
implements JoyQueueCommandHandler,
Type,
JoyQueueContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(FetchAssignedPartitionRequestHandler.class);
    private Coordinator coordinator;
    private PartitionAssignmentHandler partitionAssignmentHandler;
    private NameService nameService;

    @Override
    public void setJoyQueueContext(JoyQueueContext joyQueueContext) {
        this.coordinator = joyQueueContext.getCoordinator();
        this.partitionAssignmentHandler = joyQueueContext.getPartitionAssignmentHandler();
        this.nameService = joyQueueContext.getBrokerContext().getNameService();
    }

    public Command handle(Transport transport, Command command) {
        FetchAssignedPartitionRequest fetchAssignedPartitionRequest = (FetchAssignedPartitionRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        String connectionId = ((InetSocketAddress)transport.remoteAddress()).getHostString();
        if (connection == null || !connection.isAuthorized(fetchAssignedPartitionRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)fetchAssignedPartitionRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        if (!this.coordinator.isCurrentGroup(fetchAssignedPartitionRequest.getApp())) {
            logger.warn("coordinator is not current, app: {}, topics: {}, transport: {}", new Object[]{fetchAssignedPartitionRequest.getApp(), fetchAssignedPartitionRequest.getData(), transport});
            return BooleanAck.build((int)JoyQueueCode.FW_COORDINATOR_NOT_AVAILABLE.getCode());
        }
        HashMap topicPartitions = Maps.newHashMapWithExpectedSize((int)fetchAssignedPartitionRequest.getData().size());
        for (FetchAssignedPartitionData fetchAssignedPartitionData : fetchAssignedPartitionRequest.getData()) {
            FetchAssignedPartitionAckData fetchAssignedPartitionAckData = this.assignPartition(fetchAssignedPartitionData, fetchAssignedPartitionRequest.getApp(), connection.getRegion(), connectionId, connection.getAddressStr());
            if (fetchAssignedPartitionAckData == null) {
                logger.warn("partitionAssignment is null, topic: {}, app: {}, transport: {}", new Object[]{fetchAssignedPartitionData, fetchAssignedPartitionRequest.getApp(), transport});
                fetchAssignedPartitionAckData = new FetchAssignedPartitionAckData(JoyQueueCode.FW_COORDINATOR_PARTITION_ASSIGNOR_ERROR);
            }
            topicPartitions.put(fetchAssignedPartitionData.getTopic(), fetchAssignedPartitionAckData);
        }
        FetchAssignedPartitionResponse fetchAssignedPartitionResponse = new FetchAssignedPartitionResponse();
        fetchAssignedPartitionResponse.setTopicPartitions((Map)topicPartitions);
        return new Command((Object)fetchAssignedPartitionResponse);
    }

    protected FetchAssignedPartitionAckData assignPartition(FetchAssignedPartitionData fetchAssignedPartitionData, String app, String region, String connectionId, String connectionHost) {
        TopicName topicName = TopicName.parse((String)fetchAssignedPartitionData.getTopic());
        TopicConfig topicConfig = this.nameService.getTopicConfig(topicName);
        if (topicConfig == null) {
            return null;
        }
        ArrayList topicPartitionGroups = null;
        topicPartitionGroups = fetchAssignedPartitionData.isNearby() ? this.getTopicRegionPartitionGroup(topicConfig, region) : Lists.newArrayList(topicConfig.getPartitionGroups().values());
        if (CollectionUtils.isEmpty((Collection)topicPartitionGroups)) {
            return new FetchAssignedPartitionAckData(JoyQueueCode.FW_COORDINATOR_PARTITION_ASSIGNOR_NO_PARTITIONS);
        }
        PartitionAssignment partitionAssignment = this.partitionAssignmentHandler.assign(fetchAssignedPartitionData.getTopic(), app, connectionId, connectionHost, fetchAssignedPartitionData.getSessionTimeout(), topicPartitionGroups);
        return new FetchAssignedPartitionAckData(partitionAssignment.getPartitions(), JoyQueueCode.SUCCESS);
    }

    protected List<PartitionGroup> getTopicRegionPartitionGroup(TopicConfig topicConfig, String region) {
        Collection partitionGroups = topicConfig.getPartitionGroups().values();
        ArrayList result = Lists.newArrayListWithCapacity((int)partitionGroups.size());
        for (PartitionGroup partitionGroup : partitionGroups) {
            if (partitionGroup.getLeaderBroker() == null) continue;
            DataCenter brokerDataCenter = this.nameService.getDataCenter(partitionGroup.getLeaderBroker().getIp());
            if (!StringUtils.isBlank((CharSequence)region) && brokerDataCenter != null && !StringUtils.equals((CharSequence)brokerDataCenter.getRegion(), (CharSequence)region)) continue;
            result.add(partitionGroup);
        }
        return result;
    }

    public int type() {
        return JoyQueueCommandType.FETCH_ASSIGNED_PARTITION_REQUEST.getCode();
    }
}

