/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterNameService;
import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.converter.BrokerNodeConverter;
import org.joyqueue.broker.protocol.converter.PolicyConverter;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.domain.TopicType;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.FetchClusterRequest;
import org.joyqueue.network.command.FetchClusterResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.Topic;
import org.joyqueue.network.command.TopicPartition;
import org.joyqueue.network.command.TopicPartitionGroup;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchClusterRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(FetchClusterRequestHandler.class);
    private BrokerConfig brokerConfig;
    private ClusterNameService clusterNameService;
    private BrokerContext brokerContext;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerConfig = brokerContext.getBrokerConfig();
        this.clusterNameService = brokerContext.getClusterNameService();
        this.brokerContext = brokerContext;
    }

    public Command handle(Transport transport, Command command) {
        FetchClusterRequest fetchClusterRequest = (FetchClusterRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(fetchClusterRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)fetchClusterRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        HashMap topics = Maps.newHashMapWithExpectedSize((int)fetchClusterRequest.getTopics().size());
        HashMap brokers = Maps.newHashMap();
        for (String topicId : fetchClusterRequest.getTopics()) {
            Topic topic = this.getTopicMetadata(connection, topicId, fetchClusterRequest.getApp(), brokers);
            topics.put(topicId, topic);
        }
        FetchClusterResponse fetchClusterResponse = new FetchClusterResponse();
        fetchClusterResponse.setTopics((Map)topics);
        fetchClusterResponse.setBrokers((Map)brokers);
        if (logger.isDebugEnabled()) {
            logger.debug("fetch cluster, address: {}, topics: {}, app: {}, metadata: {}", new Object[]{transport, fetchClusterRequest.getTopics(), fetchClusterRequest.getApp(), JSON.toJSONString((Object)fetchClusterResponse)});
        }
        return new Command((Object)fetchClusterResponse);
    }

    protected Topic getTopicMetadata(Connection connection, String topic, String app, Map<Integer, BrokerNode> brokers) {
        TopicName topicName = TopicName.parse((String)topic);
        TopicConfig topicConfig = this.clusterNameService.getTopicConfig(topicName);
        Topic result = new Topic();
        result.setTopic(topic);
        result.setType(TopicType.TOPIC);
        if (topicConfig == null) {
            logger.warn("topic not exist, topic: {}, app: {}", (Object)topic, (Object)app);
            result.setCode(JoyQueueCode.FW_TOPIC_NOT_EXIST);
            return result;
        }
        Producer producer = this.clusterNameService.getNameService().getProducerByTopicAndApp(topicName, app);
        Consumer consumer = this.clusterNameService.getNameService().getConsumerByTopicAndApp(topicName, app);
        if (producer == null && consumer == null && !connection.isSystem()) {
            logger.warn("topic policy not exist, topic: {}, app: {}", (Object)topic, (Object)app);
            result.setCode(JoyQueueCode.CN_NO_PERMISSION);
            return result;
        }
        if (producer == null) {
            if (connection.isSystem()) {
                result.setProducerPolicy(PolicyConverter.convertProducer(this.brokerContext.getProducerPolicy()));
            }
        } else if (producer.getProducerPolicy() == null) {
            result.setProducerPolicy(PolicyConverter.convertProducer(this.brokerContext.getProducerPolicy()));
        } else {
            result.setProducerPolicy(PolicyConverter.convertProducer(producer.getProducerPolicy()));
        }
        if (consumer == null) {
            if (connection.isSystem()) {
                result.setConsumerPolicy(PolicyConverter.convertConsumer(this.brokerContext.getConsumerPolicy()));
                result.setType(TopicType.TOPIC);
            }
        } else {
            if (consumer.getConsumerPolicy() == null) {
                result.setConsumerPolicy(PolicyConverter.convertConsumer(this.brokerContext.getConsumerPolicy()));
            } else {
                result.setConsumerPolicy(PolicyConverter.convertConsumer(consumer.getConsumerPolicy()));
            }
            result.setType(consumer.getTopicType());
        }
        result.setCode(JoyQueueCode.SUCCESS);
        result.setPartitionGroups(this.convertTopicPartitionGroups(connection, topicConfig.getPartitionGroups().values(), brokers));
        return result;
    }

    protected Map<Integer, TopicPartitionGroup> convertTopicPartitionGroups(Connection connection, Collection<PartitionGroup> partitionGroups, Map<Integer, BrokerNode> brokers) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (PartitionGroup partitionGroup : partitionGroups) {
            TopicPartitionGroup topicPartitionGroup = this.convertTopicPartitionGroup(connection, partitionGroup, brokers);
            if (topicPartitionGroup == null) continue;
            result.put(partitionGroup.getGroup(), topicPartitionGroup);
        }
        return result;
    }

    protected TopicPartitionGroup convertTopicPartitionGroup(Connection connection, PartitionGroup partitionGroup, Map<Integer, BrokerNode> brokers) {
        LinkedHashMap partitions = Maps.newLinkedHashMap();
        Broker leaderBroker = partitionGroup.getLeaderBroker();
        if (leaderBroker != null) {
            DataCenter brokerDataCenter = this.clusterNameService.getNameService().getDataCenter(leaderBroker.getIp());
            brokers.put(partitionGroup.getLeader(), BrokerNodeConverter.convertBrokerNode(leaderBroker, brokerDataCenter, connection.getRegion()));
        }
        for (Short partition : partitionGroup.getPartitions()) {
            partitions.put(partition, this.convertTopicPartition(partitionGroup, partition));
        }
        TopicPartitionGroup result = new TopicPartitionGroup();
        result.setId(partitionGroup.getGroup());
        result.setLeader(partitionGroup.getLeader().intValue());
        result.setPartitions((Map)partitions);
        return result;
    }

    protected TopicPartition convertTopicPartition(PartitionGroup partitionGroup, short partition) {
        TopicPartition result = new TopicPartition();
        result.setId(partition);
        return result;
    }

    public int type() {
        return JoyQueueCommandType.FETCH_CLUSTER_REQUEST.getCode();
    }
}

