/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.FetchIndexData;
import org.joyqueue.network.command.FetchIndexRequest;
import org.joyqueue.network.command.FetchIndexResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchIndexRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(FetchIndexRequestHandler.class);
    private Consume consume;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.consume = brokerContext.getConsume();
    }

    public Command handle(Transport transport, Command command) {
        FetchIndexRequest fetchIndexRequest = (FetchIndexRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(fetchIndexRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)fetchIndexRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        HashBasedTable result = HashBasedTable.create();
        for (Map.Entry entry : fetchIndexRequest.getPartitions().entrySet()) {
            String topic = (String)entry.getKey();
            Consumer consumer = new Consumer(connection.getId(), topic, fetchIndexRequest.getApp(), Consumer.ConsumeType.JOYQUEUE);
            for (Short partition : (List)entry.getValue()) {
                FetchIndexData fetchIndexData = this.fetchIndex(connection, consumer, partition);
                result.put((Object)topic, (Object)partition, (Object)fetchIndexData);
            }
        }
        FetchIndexResponse fetchIndexResponse = new FetchIndexResponse();
        fetchIndexResponse.setData((Table)result);
        return new Command((Object)fetchIndexResponse);
    }

    protected FetchIndexData fetchIndex(Connection connection, Consumer consumer, short partition) {
        FetchIndexData fetchIndexData = new FetchIndexData();
        try {
            long leftIndex = this.consume.getMinIndex(consumer, partition);
            long rightIndex = this.consume.getMaxIndex(consumer, partition);
            long index = this.consume.getAckIndex(consumer, partition);
            fetchIndexData.setIndex(index);
            fetchIndexData.setLeftIndex(leftIndex);
            fetchIndexData.setRightIndex(rightIndex);
            fetchIndexData.setCode(JoyQueueCode.SUCCESS);
        }
        catch (Exception e) {
            fetchIndexData.setCode(JoyQueueCode.CN_UNKNOWN_ERROR);
            logger.error("fetchIndex exception, consumer: {}, partition: {}, transport: {}", new Object[]{consumer, partition, connection.getTransport(), e});
        }
        return fetchIndexData;
    }

    public int type() {
        return JoyQueueCommandType.FETCH_INDEX_REQUEST.getCode();
    }
}

