/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Map;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.network.traffic.Traffic;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.command.FetchPartitionMessageRequest;
import org.joyqueue.broker.protocol.command.FetchPartitionMessageResponse;
import org.joyqueue.broker.protocol.converter.CheckResultConverter;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.FetchPartitionMessageAckData;
import org.joyqueue.network.command.FetchPartitionMessageData;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.protocol.annotation.FetchHandler;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.response.BooleanResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FetchHandler
public class FetchPartitionMessageRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(FetchPartitionMessageRequestHandler.class);
    private Consume consume;
    private ClusterManager clusterManager;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.consume = brokerContext.getConsume();
        this.clusterManager = brokerContext.getClusterManager();
    }

    public Command handle(Transport transport, Command command) {
        FetchPartitionMessageRequest fetchPartitionMessageRequest = (FetchPartitionMessageRequest)((Object)command.getPayload());
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(fetchPartitionMessageRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)fetchPartitionMessageRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        HashBasedTable result = HashBasedTable.create();
        Traffic traffic = new Traffic(fetchPartitionMessageRequest.getApp());
        for (Map.Entry entry : fetchPartitionMessageRequest.getPartitions().rowMap().entrySet()) {
            String topic = (String)entry.getKey();
            Consumer consumer = new Consumer(connection.getId(), topic, fetchPartitionMessageRequest.getApp(), Consumer.ConsumeType.JOYQUEUE);
            for (Map.Entry partitionEntry : ((Map)entry.getValue()).entrySet()) {
                short partition = (Short)partitionEntry.getKey();
                BooleanResponse checkResult = this.clusterManager.checkReadable(TopicName.parse((String)topic), fetchPartitionMessageRequest.getApp(), connection.getHost(), partition);
                if (!checkResult.isSuccess()) {
                    logger.warn("checkReadable failed, transport: {}, topic: {}, partition: {}, app: {}, code: {}", new Object[]{transport, consumer.getTopic(), partition, consumer.getApp(), checkResult.getJoyQueueCode()});
                    result.put((Object)topic, partitionEntry.getKey(), (Object)new FetchPartitionMessageAckData(CheckResultConverter.convertFetchCode(command.getHeader().getVersion(), checkResult.getJoyQueueCode())));
                    continue;
                }
                if (fetchPartitionMessageRequest.getTraffic().isLimited((String)entry.getKey())) {
                    result.put((Object)topic, partitionEntry.getKey(), (Object)new FetchPartitionMessageAckData(JoyQueueCode.SUCCESS));
                    continue;
                }
                FetchPartitionMessageData fetchPartitionMessageData = (FetchPartitionMessageData)partitionEntry.getValue();
                FetchPartitionMessageAckData fetchPartitionMessageAckData = this.fetchMessage(transport, consumer, partition, fetchPartitionMessageData.getIndex(), fetchPartitionMessageData.getCount());
                result.put((Object)topic, partitionEntry.getKey(), (Object)fetchPartitionMessageAckData);
                traffic.record(topic, fetchPartitionMessageAckData.getTraffic(), fetchPartitionMessageAckData.getSize());
            }
        }
        FetchPartitionMessageResponse fetchPartitionMessageResponse = new FetchPartitionMessageResponse();
        fetchPartitionMessageResponse.setTraffic(traffic);
        fetchPartitionMessageResponse.setData((Table)result);
        return new Command((Object)fetchPartitionMessageResponse);
    }

    protected FetchPartitionMessageAckData fetchMessage(Transport transport, Consumer consumer, short partition, long index, int count) {
        FetchPartitionMessageAckData fetchPartitionMessageAckData = new FetchPartitionMessageAckData();
        fetchPartitionMessageAckData.setBuffers(Collections.emptyList());
        try {
            long minIndex = this.consume.getMinIndex(consumer, partition);
            long maxIndex = this.consume.getMaxIndex(consumer, partition);
            if (index == -1L && (index = this.consume.getAckIndex(consumer, partition)) < minIndex) {
                logger.warn("fetchPartitionMessage exception, index reset to minIndex, transport: {}, consumer: {}, partition: {}, index: {}, minIndex: {}, maxIndex: {}", new Object[]{transport, consumer, partition, index, minIndex, maxIndex});
                index = minIndex;
            }
            if (index < minIndex || index > maxIndex) {
                logger.warn("fetchPartitionMessage exception, index ou of range, transport: {}, consumer: {}, partition: {}, index: {}, minIndex: {}, maxIndex: {}", new Object[]{transport, consumer, partition, index, minIndex, maxIndex});
                fetchPartitionMessageAckData.setCode(JoyQueueCode.FW_FETCH_MESSAGE_INDEX_OUT_OF_RANGE);
            } else {
                PullResult pullResult = this.consume.getMessage(consumer, partition, index, count);
                if (!pullResult.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                    logger.error("fetchPartitionMessage exception, transport: {}, consumer: {}, partition: {}, index: {}, minIndex: {}, maxIndex: {}", new Object[]{transport, consumer, partition, index, minIndex, maxIndex});
                }
                fetchPartitionMessageAckData.setBuffers(pullResult.getBuffers());
                fetchPartitionMessageAckData.setCode(pullResult.getCode());
            }
        }
        catch (JoyQueueException e) {
            logger.error("fetchPartitionMessage exception, transport: {}, consumer: {}, partition: {}, index: {}", new Object[]{transport, consumer, partition, index, e});
            fetchPartitionMessageAckData.setCode(JoyQueueCode.valueOf((int)e.getCode()));
        }
        catch (Exception e) {
            logger.error("fetchPartitionMessage exception, transport: {}, consumer: {}, partition: {}, index: {}", new Object[]{transport, consumer, partition, index, e});
            fetchPartitionMessageAckData.setCode(JoyQueueCode.CN_UNKNOWN_ERROR);
        }
        return fetchPartitionMessageAckData;
    }

    public int type() {
        return JoyQueueCommandType.FETCH_PARTITION_MESSAGE_REQUEST.getCode();
    }
}

