/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.converter.CheckResultConverter;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.FetchProduceFeedbackAckData;
import org.joyqueue.network.command.FetchProduceFeedbackRequest;
import org.joyqueue.network.command.FetchProduceFeedbackResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.protocol.annotation.FetchHandler;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.session.TransactionId;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.response.BooleanResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FetchHandler
public class FetchProduceFeedbackRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(FetchProduceFeedbackRequestHandler.class);
    private Produce produce;
    private ClusterManager clusterManager;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.produce = brokerContext.getProduce();
        this.clusterManager = brokerContext.getClusterManager();
    }

    public Command handle(Transport transport, Command command) {
        FetchProduceFeedbackRequest fetchProduceFeedbackRequest = (FetchProduceFeedbackRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(fetchProduceFeedbackRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)fetchProduceFeedbackRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        BooleanResponse checkResult = this.clusterManager.checkWritable(TopicName.parse((String)fetchProduceFeedbackRequest.getTopic()), fetchProduceFeedbackRequest.getApp(), connection.getHost());
        if (!checkResult.isSuccess()) {
            logger.warn("checkWritable failed, transport: {}, topic: {}, app: {}, code: {}", new Object[]{transport, fetchProduceFeedbackRequest.getTopic(), fetchProduceFeedbackRequest.getApp(), checkResult.getJoyQueueCode()});
            return new Command((Object)new FetchProduceFeedbackResponse(CheckResultConverter.convertCommonCode(command.getHeader().getVersion(), checkResult.getJoyQueueCode())));
        }
        FetchProduceFeedbackResponse fetchProduceFeedbackResponse = this.fetchProduceFeedback(connection, fetchProduceFeedbackRequest);
        return new Command((Object)fetchProduceFeedbackResponse);
    }

    protected FetchProduceFeedbackResponse fetchProduceFeedback(Connection connection, FetchProduceFeedbackRequest fetchProduceFeedbackRequest) {
        Producer producer = new Producer(connection.getId(), fetchProduceFeedbackRequest.getTopic(), fetchProduceFeedbackRequest.getApp(), Producer.ProducerType.JOYQUEUE);
        try {
            FetchProduceFeedbackResponse fetchProduceFeedbackResponse = new FetchProduceFeedbackResponse();
            List transactionIdList = this.produce.getFeedback(producer, fetchProduceFeedbackRequest.getCount());
            fetchProduceFeedbackResponse.setData(this.buildFeedbackAckData(transactionIdList));
            fetchProduceFeedbackResponse.setCode(JoyQueueCode.SUCCESS);
            return fetchProduceFeedbackResponse;
        }
        catch (JoyQueueException e) {
            logger.error("fetch feedback exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), fetchProduceFeedbackRequest.getTopic(), fetchProduceFeedbackRequest.getApp(), e});
            return new FetchProduceFeedbackResponse(JoyQueueCode.valueOf((int)e.getCode()));
        }
        catch (Exception e) {
            logger.error("fetch feedback exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), fetchProduceFeedbackRequest.getTopic(), fetchProduceFeedbackRequest.getApp(), e});
            return new FetchProduceFeedbackResponse(JoyQueueCode.CN_UNKNOWN_ERROR);
        }
    }

    protected List<FetchProduceFeedbackAckData> buildFeedbackAckData(List<TransactionId> transactionIdList) {
        ArrayList result = Lists.newArrayListWithCapacity((int)transactionIdList.size());
        for (TransactionId transactionId : transactionIdList) {
            result.add(new FetchProduceFeedbackAckData(transactionId.getTopic(), transactionId.getTxId(), transactionId.getQueryId()));
        }
        return result;
    }

    public int type() {
        return JoyQueueCommandType.FETCH_PRODUCE_FEEDBACK_REQUEST.getCode();
    }
}

