/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.polling.LongPollingCallback;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.command.FetchTopicMessageAckData;
import org.joyqueue.network.command.FetchTopicMessageRequest;
import org.joyqueue.network.command.FetchTopicMessageResponse;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchTopicMessageLongPollCallback
implements LongPollingCallback {
    protected static final Logger logger = LoggerFactory.getLogger(FetchTopicMessageLongPollCallback.class);
    private FetchTopicMessageRequest fetchTopicMessageRequest;
    private Command request;
    private Transport transport;

    public FetchTopicMessageLongPollCallback(FetchTopicMessageRequest fetchTopicMessageRequest, Command request, Transport transport) {
        this.fetchTopicMessageRequest = fetchTopicMessageRequest;
        this.request = request;
        this.transport = transport;
    }

    public void onSuccess(Consumer consumer, PullResult pullResult) throws TransportException {
        FetchTopicMessageAckData fetchTopicMessageAckData = new FetchTopicMessageAckData();
        fetchTopicMessageAckData.setBuffers(pullResult.getBuffers());
        fetchTopicMessageAckData.setCode(pullResult.getCode());
        this.transport.acknowledge(this.request, new Command((Object)this.buildFetchTopicMessageAck(consumer, fetchTopicMessageAckData)));
    }

    public void onExpire(Consumer consumer) throws TransportException {
        FetchTopicMessageAckData fetchTopicMessageAckData = new FetchTopicMessageAckData();
        fetchTopicMessageAckData.setBuffers(Collections.emptyList());
        fetchTopicMessageAckData.setCode(JoyQueueCode.SUCCESS);
        this.transport.acknowledge(this.request, new Command((Object)this.buildFetchTopicMessageAck(consumer, fetchTopicMessageAckData)));
    }

    public void onException(Consumer consumer, Throwable throwable) throws TransportException {
        logger.error("fetchTopicMessage longPolling exception, transport: {}, consumer: {}", new Object[]{this.transport, consumer, throwable});
        FetchTopicMessageAckData fetchTopicMessageAckData = new FetchTopicMessageAckData();
        fetchTopicMessageAckData.setBuffers(Collections.emptyList());
        if (throwable instanceof JoyQueueException) {
            fetchTopicMessageAckData.setCode(JoyQueueCode.valueOf((int)((JoyQueueException)throwable).getCode()));
        } else {
            fetchTopicMessageAckData.setCode(JoyQueueCode.CN_UNKNOWN_ERROR);
        }
        this.transport.acknowledge(this.request, new Command((Object)this.buildFetchTopicMessageAck(consumer, fetchTopicMessageAckData)));
    }

    protected FetchTopicMessageResponse buildFetchTopicMessageAck(Consumer consumer, FetchTopicMessageAckData data) {
        HashMap dataMap = Maps.newHashMap();
        dataMap.put(consumer.getTopic(), data);
        FetchTopicMessageResponse fetchTopicMessageResponse = new FetchTopicMessageResponse();
        fetchTopicMessageResponse.setData((Map)dataMap);
        return fetchTopicMessageResponse;
    }
}

