/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.network.traffic.Traffic;
import org.joyqueue.broker.polling.LongPolling;
import org.joyqueue.broker.polling.LongPollingCallback;
import org.joyqueue.broker.polling.LongPollingManager;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.JoyQueueContext;
import org.joyqueue.broker.protocol.JoyQueueContextAware;
import org.joyqueue.broker.protocol.command.FetchTopicMessageRequest;
import org.joyqueue.broker.protocol.command.FetchTopicMessageResponse;
import org.joyqueue.broker.protocol.converter.CheckResultConverter;
import org.joyqueue.broker.protocol.handler.FetchTopicMessageLongPollCallback;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.FetchTopicMessageAckData;
import org.joyqueue.network.command.FetchTopicMessageData;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.protocol.annotation.FetchHandler;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.response.BooleanResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FetchHandler
public class FetchTopicMessageRequestHandler
implements JoyQueueCommandHandler,
Type,
JoyQueueContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(FetchTopicMessageRequestHandler.class);
    private Consume consume;
    private SessionManager sessionManager;
    private ClusterManager clusterManager;
    private LongPollingManager longPollingManager;

    @Override
    public void setJoyQueueContext(JoyQueueContext joyQueueContext) {
        this.consume = joyQueueContext.getBrokerContext().getConsume();
        this.sessionManager = joyQueueContext.getBrokerContext().getSessionManager();
        this.clusterManager = joyQueueContext.getBrokerContext().getClusterManager();
        this.longPollingManager = joyQueueContext.getLongPollingManager();
    }

    public Command handle(Transport transport, Command command) {
        FetchTopicMessageRequest fetchTopicMessageRequest = (FetchTopicMessageRequest)((Object)command.getPayload());
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(fetchTopicMessageRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}, topics: {}", new Object[]{transport, fetchTopicMessageRequest.getApp(), fetchTopicMessageRequest.getTopics().keySet()});
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        boolean isNeedLongPoll = fetchTopicMessageRequest.getTopics().size() == 1 && fetchTopicMessageRequest.getLongPollTimeout() > 0;
        HashMap result = Maps.newHashMapWithExpectedSize((int)fetchTopicMessageRequest.getTopics().size());
        Traffic traffic = new Traffic(fetchTopicMessageRequest.getApp());
        for (Map.Entry entry : fetchTopicMessageRequest.getTopics().entrySet()) {
            Consumer consumer;
            String topic = (String)entry.getKey();
            BooleanResponse checkResult = this.clusterManager.checkReadable(TopicName.parse((String)topic), fetchTopicMessageRequest.getApp(), connection.getHost());
            if (!checkResult.isSuccess()) {
                logger.warn("checkReadable failed, transport: {}, topic: {}, app: {}, code: {}", new Object[]{transport, topic, fetchTopicMessageRequest.getApp(), checkResult.getJoyQueueCode()});
                result.put(topic, new FetchTopicMessageAckData(CheckResultConverter.convertFetchCode(command.getHeader().getVersion(), checkResult.getJoyQueueCode())));
                continue;
            }
            if (fetchTopicMessageRequest.getTraffic().isLimited(topic)) {
                result.put(topic, new FetchTopicMessageAckData(JoyQueueCode.SUCCESS));
                continue;
            }
            String consumerId = connection.getConsumer(topic, fetchTopicMessageRequest.getApp());
            Consumer consumer2 = consumer = StringUtils.isBlank((CharSequence)consumerId) ? null : this.sessionManager.getConsumerById(consumerId);
            if (consumer == null) {
                logger.warn("connection is not exists, transport: {}, app: {}, topics: {}", new Object[]{transport, fetchTopicMessageRequest.getApp(), fetchTopicMessageRequest.getTopics().keySet()});
                result.put(topic, new FetchTopicMessageAckData(CheckResultConverter.convertFetchCode(command.getHeader().getVersion(), JoyQueueCode.FW_CONSUMER_NOT_EXISTS)));
                continue;
            }
            FetchTopicMessageData fetchTopicMessageData = (FetchTopicMessageData)entry.getValue();
            FetchTopicMessageAckData fetchTopicMessageAckData = this.fetchMessage(transport, consumer, fetchTopicMessageData.getCount(), fetchTopicMessageRequest.getAckTimeout());
            if (isNeedLongPoll && CollectionUtils.isEmpty((Collection)fetchTopicMessageAckData.getBuffers()) && this.clusterManager.isNeedLongPull(consumer.getTopic()) && this.longPollingManager.suspend(new LongPolling(consumer, fetchTopicMessageData.getCount(), fetchTopicMessageRequest.getAckTimeout(), (long)fetchTopicMessageRequest.getLongPollTimeout(), (LongPollingCallback)new FetchTopicMessageLongPollCallback(fetchTopicMessageRequest, command, transport)))) {
                return null;
            }
            traffic.record(topic, fetchTopicMessageAckData.getTraffic(), fetchTopicMessageAckData.getSize());
            result.put(topic, fetchTopicMessageAckData);
        }
        FetchTopicMessageResponse fetchTopicMessageResponse = new FetchTopicMessageResponse();
        fetchTopicMessageResponse.setTraffic(traffic);
        fetchTopicMessageResponse.setData(result);
        return new Command((Object)fetchTopicMessageResponse);
    }

    protected FetchTopicMessageAckData fetchMessage(Transport transport, Consumer consumer, int count, int ackTimeout) {
        FetchTopicMessageAckData fetchTopicMessageAckData = new FetchTopicMessageAckData();
        fetchTopicMessageAckData.setBuffers(Collections.emptyList());
        try {
            PullResult pullResult = this.consume.getMessage(consumer, count, ackTimeout);
            if (!pullResult.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                logger.error("fetchTopicMessage exception, transport: {}, consumer: {}, count: {}", new Object[]{transport, consumer, count});
            }
            fetchTopicMessageAckData.setBuffers(pullResult.getBuffers());
            fetchTopicMessageAckData.setCode(pullResult.getCode());
        }
        catch (JoyQueueException e) {
            logger.error("fetchTopicMessage exception, transport: {}, consumer: {}, count: {}", new Object[]{transport, consumer, count, e});
            fetchTopicMessageAckData.setCode(JoyQueueCode.valueOf((int)e.getCode()));
        }
        catch (Exception e) {
            logger.error("fetchTopicMessage exception, transport: {}, consumer: {}, count: {}", new Object[]{transport, consumer, count, e});
            fetchTopicMessageAckData.setCode(JoyQueueCode.CN_UNKNOWN_ERROR);
        }
        return fetchTopicMessageAckData;
    }

    public int type() {
        return JoyQueueCommandType.FETCH_TOPIC_MESSAGE_REQUEST.getCode();
    }
}

