/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.JoyQueueContext;
import org.joyqueue.broker.protocol.JoyQueueContextAware;
import org.joyqueue.broker.protocol.converter.BrokerNodeConverter;
import org.joyqueue.broker.protocol.coordinator.Coordinator;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.DataCenter;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.FindCoordinatorAckData;
import org.joyqueue.network.command.FindCoordinatorRequest;
import org.joyqueue.network.command.FindCoordinatorResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.nsr.NameService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindCoordinatorRequestHandler
implements JoyQueueCommandHandler,
Type,
JoyQueueContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(FindCoordinatorRequestHandler.class);
    private Coordinator coordinator;
    private NameService nameService;

    @Override
    public void setJoyQueueContext(JoyQueueContext joyQueueContext) {
        this.coordinator = joyQueueContext.getCoordinator();
        this.nameService = joyQueueContext.getBrokerContext().getNameService();
    }

    public Command handle(Transport transport, Command command) {
        FindCoordinatorRequest findCoordinatorRequest = (FindCoordinatorRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(findCoordinatorRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)findCoordinatorRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        Map<String, FindCoordinatorAckData> coordinators = this.findCoordinators(connection, findCoordinatorRequest.getTopics(), findCoordinatorRequest.getApp());
        FindCoordinatorResponse findCoordinatorResponse = new FindCoordinatorResponse();
        findCoordinatorResponse.setCoordinators(coordinators);
        return new Command((Object)findCoordinatorResponse);
    }

    protected Map<String, FindCoordinatorAckData> findCoordinators(Connection connection, List<String> topics, String app) {
        Broker coordinatorBroker = this.coordinator.findGroup(app);
        JoyQueueCode code = JoyQueueCode.SUCCESS;
        BrokerNode coordinatorNode = null;
        if (coordinatorBroker != null) {
            DataCenter brokerDataCenter = this.nameService.getDataCenter(coordinatorBroker.getIp());
            coordinatorNode = BrokerNodeConverter.convertBrokerNode(coordinatorBroker, brokerDataCenter, connection.getRegion());
        } else {
            logger.warn("find coordinator error, coordinator not exist, topics: {}, app: {}, remoteAddress: {}", new Object[]{topics, app, connection.getAddressStr()});
            code = JoyQueueCode.FW_COORDINATOR_NOT_AVAILABLE;
        }
        HashMap result = Maps.newHashMap();
        for (String topic : topics) {
            result.put(topic, new FindCoordinatorAckData(coordinatorNode, code));
        }
        return result;
    }

    public int type() {
        return JoyQueueCommandType.FIND_COORDINATOR_REQUEST.getCode();
    }
}

