/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.converter.CheckResultConverter;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerCommit;
import org.joyqueue.message.JoyQueueLog;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.ProduceMessageCommitRequest;
import org.joyqueue.network.command.ProduceMessageCommitResponse;
import org.joyqueue.network.protocol.annotation.ProduceHandler;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.response.BooleanResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProduceHandler
public class ProduceMessageCommitRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(ProduceMessageCommitRequestHandler.class);
    private Produce produce;
    private ClusterManager clusterManager;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.produce = brokerContext.getProduce();
        this.clusterManager = brokerContext.getClusterManager();
    }

    public Command handle(Transport transport, Command command) {
        ProduceMessageCommitRequest produceMessageCommitRequest = (ProduceMessageCommitRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(produceMessageCommitRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)produceMessageCommitRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        BooleanResponse checkResult = this.clusterManager.checkWritable(TopicName.parse((String)produceMessageCommitRequest.getTopic()), produceMessageCommitRequest.getApp(), connection.getHost());
        if (!checkResult.isSuccess()) {
            logger.warn("checkWritable failed, transport: {}, topic: {}, app: {}, code: {}", new Object[]{transport, produceMessageCommitRequest.getTopic(), produceMessageCommitRequest.getApp(), checkResult.getJoyQueueCode()});
            return new Command((Object)new ProduceMessageCommitResponse(CheckResultConverter.convertCommonCode(command.getHeader().getVersion(), checkResult.getJoyQueueCode())));
        }
        ProduceMessageCommitResponse produceMessageCommitResponse = this.produceMessageCommit(connection, produceMessageCommitRequest);
        return new Command((Object)produceMessageCommitResponse);
    }

    protected ProduceMessageCommitResponse produceMessageCommit(Connection connection, ProduceMessageCommitRequest produceMessageCommitRequest) {
        Producer producer = new Producer(connection.getId(), produceMessageCommitRequest.getTopic(), produceMessageCommitRequest.getApp(), Producer.ProducerType.JOYQUEUE);
        BrokerCommit brokerCommit = new BrokerCommit();
        brokerCommit.setTopic(produceMessageCommitRequest.getTopic());
        brokerCommit.setApp(produceMessageCommitRequest.getApp());
        brokerCommit.setTxId(produceMessageCommitRequest.getTxId());
        try {
            this.produce.putTransactionMessage(producer, (JoyQueueLog)brokerCommit);
            return new ProduceMessageCommitResponse(JoyQueueCode.SUCCESS);
        }
        catch (JoyQueueException e) {
            logger.error("produceMessage commit exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), produceMessageCommitRequest.getTopic(), produceMessageCommitRequest.getApp(), e});
            return new ProduceMessageCommitResponse(JoyQueueCode.valueOf((int)e.getCode()));
        }
        catch (Exception e) {
            logger.error("produceMessage commit exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), produceMessageCommitRequest.getTopic(), produceMessageCommitRequest.getApp(), e});
            return new ProduceMessageCommitResponse(JoyQueueCode.CN_UNKNOWN_ERROR);
        }
    }

    public int type() {
        return JoyQueueCommandType.PRODUCE_MESSAGE_COMMIT_REQUEST.getCode();
    }
}

