/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.converter.CheckResultConverter;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerPrepare;
import org.joyqueue.message.JoyQueueLog;
import org.joyqueue.message.SourceType;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.ProduceMessagePrepareRequest;
import org.joyqueue.network.command.ProduceMessagePrepareResponse;
import org.joyqueue.network.protocol.annotation.ProduceHandler;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.session.TransactionId;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.response.BooleanResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProduceHandler
public class ProduceMessagePrepareRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(ProduceMessagePrepareRequestHandler.class);
    private Produce produce;
    private ClusterManager clusterManager;
    private SessionManager sessionManager;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.produce = brokerContext.getProduce();
        this.clusterManager = brokerContext.getClusterManager();
        this.sessionManager = brokerContext.getSessionManager();
    }

    public Command handle(Transport transport, Command command) {
        Producer producer;
        ProduceMessagePrepareRequest produceMessagePrepareRequest = (ProduceMessagePrepareRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(produceMessagePrepareRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)produceMessagePrepareRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        String producerId = connection.getProducer(produceMessagePrepareRequest.getTopic(), produceMessagePrepareRequest.getApp());
        Producer producer2 = producer = StringUtils.isBlank((CharSequence)producerId) ? null : this.sessionManager.getProducerById(producerId);
        if (producer == null) {
            logger.warn("producer is not exists, transport: {}", (Object)transport);
            return BooleanAck.build((int)JoyQueueCode.FW_PRODUCER_NOT_EXISTS.getCode());
        }
        BooleanResponse checkResult = this.clusterManager.checkWritable(TopicName.parse((String)produceMessagePrepareRequest.getTopic()), produceMessagePrepareRequest.getApp(), connection.getHost());
        if (!checkResult.isSuccess()) {
            logger.warn("checkWritable failed, transport: {}, topic: {}, app: {}, code: {}", new Object[]{transport, produceMessagePrepareRequest, produceMessagePrepareRequest.getApp(), checkResult.getJoyQueueCode()});
            return new Command((Object)new ProduceMessagePrepareResponse(CheckResultConverter.convertCommonCode(command.getHeader().getVersion(), checkResult.getJoyQueueCode())));
        }
        ProduceMessagePrepareResponse produceMessagePrepareResponse = this.produceMessagePrepare(producer, connection, produceMessagePrepareRequest);
        return new Command((Object)produceMessagePrepareResponse);
    }

    protected ProduceMessagePrepareResponse produceMessagePrepare(Producer producer, Connection connection, ProduceMessagePrepareRequest produceMessagePrepareRequest) {
        BrokerPrepare brokerPrepare = new BrokerPrepare();
        brokerPrepare.setTopic(produceMessagePrepareRequest.getTopic());
        brokerPrepare.setApp(produceMessagePrepareRequest.getApp());
        brokerPrepare.setQueryId(produceMessagePrepareRequest.getTransactionId());
        brokerPrepare.setTimeout((long)produceMessagePrepareRequest.getTimeout());
        brokerPrepare.setSource(SourceType.JOYQUEUE.getValue());
        try {
            TransactionId transactionId = this.produce.putTransactionMessage(producer, (JoyQueueLog)brokerPrepare);
            return new ProduceMessagePrepareResponse(transactionId.getTxId(), JoyQueueCode.SUCCESS);
        }
        catch (JoyQueueException e) {
            logger.error("produceMessage prepare exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), produceMessagePrepareRequest.getTopic(), produceMessagePrepareRequest.getApp(), e});
            return new ProduceMessagePrepareResponse(JoyQueueCode.valueOf((int)e.getCode()));
        }
        catch (Exception e) {
            logger.error("produceMessage prepare exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), produceMessagePrepareRequest.getTopic(), produceMessagePrepareRequest.getApp(), e});
            return new ProduceMessagePrepareResponse(JoyQueueCode.CN_UNKNOWN_ERROR);
        }
    }

    public int type() {
        return JoyQueueCommandType.PRODUCE_MESSAGE_PREPARE_REQUEST.getCode();
    }
}

