/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.network.traffic.Traffic;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.broker.producer.ProduceConfig;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.JoyQueueContext;
import org.joyqueue.broker.protocol.JoyQueueContextAware;
import org.joyqueue.broker.protocol.command.ProduceMessageResponse;
import org.joyqueue.broker.protocol.config.JoyQueueConfig;
import org.joyqueue.broker.protocol.converter.CheckResultConverter;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.ProduceMessageAckData;
import org.joyqueue.network.command.ProduceMessageAckItemData;
import org.joyqueue.network.command.ProduceMessageData;
import org.joyqueue.network.command.ProduceMessageRequest;
import org.joyqueue.network.protocol.annotation.ProduceHandler;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.response.BooleanResponse;
import org.joyqueue.store.WriteResult;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProduceHandler
public class ProduceMessageRequestHandler
implements JoyQueueCommandHandler,
Type,
JoyQueueContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(ProduceMessageRequestHandler.class);
    private JoyQueueConfig config;
    private ProduceConfig produceConfig;
    private Produce produce;
    private ClusterManager clusterManager;

    @Override
    public void setJoyQueueContext(JoyQueueContext joyQueueContext) {
        this.config = joyQueueContext.getConfig();
        this.produceConfig = new ProduceConfig(joyQueueContext.getBrokerContext().getPropertySupplier());
        this.produce = joyQueueContext.getBrokerContext().getProduce();
        this.clusterManager = joyQueueContext.getBrokerContext().getClusterManager();
    }

    public Command handle(Transport transport, Command command) {
        ProduceMessageRequest produceMessageRequest = (ProduceMessageRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(produceMessageRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)produceMessageRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        QosLevel qosLevel = command.getHeader().getQosLevel();
        boolean isNeedAck = !qosLevel.equals((Object)QosLevel.ONE_WAY);
        CountDownLatch latch = new CountDownLatch(produceMessageRequest.getData().size());
        ConcurrentMap resultData = Maps.newConcurrentMap();
        Traffic traffic = new Traffic(produceMessageRequest.getApp());
        for (Map.Entry entry : produceMessageRequest.getData().entrySet()) {
            String topic = (String)entry.getKey();
            ProduceMessageData produceMessageData = (ProduceMessageData)entry.getValue();
            try {
                this.checkAndFillMessage(connection, produceMessageData);
            }
            catch (JoyQueueException e) {
                logger.warn("checkMessage error, transport: {}, topic: {}, app: {}", new Object[]{transport, topic, produceMessageRequest.getApp(), e});
                resultData.put(topic, this.buildResponse(produceMessageData, JoyQueueCode.valueOf((int)e.getCode())));
                latch.countDown();
                continue;
            }
            BooleanResponse checkResult = this.clusterManager.checkWritable(TopicName.parse((String)topic), produceMessageRequest.getApp(), connection.getHost(), ((BrokerMessage)produceMessageData.getMessages().get(0)).getPartition());
            if (!checkResult.isSuccess()) {
                logger.warn("checkWritable failed, transport: {}, topic: {}, app: {}, code: {}", new Object[]{transport, topic, produceMessageRequest.getApp(), checkResult.getJoyQueueCode()});
                resultData.put(topic, this.buildResponse(produceMessageData, CheckResultConverter.convertProduceCode(command.getHeader().getVersion(), checkResult.getJoyQueueCode())));
                latch.countDown();
                continue;
            }
            this.produceMessage(connection, topic, produceMessageRequest.getApp(), produceMessageData, (EventListener<ProduceMessageAckData>)((EventListener)data -> {
                resultData.put(topic, data);
                traffic.record(topic, produceMessageData.getTraffic(), produceMessageData.getSize());
                latch.countDown();
            }));
        }
        if (!isNeedAck) {
            return null;
        }
        try {
            boolean isDone = latch.await(this.config.getProduceMaxTimeout(), TimeUnit.MILLISECONDS);
            if (!isDone) {
                logger.warn("wait produce timeout, transport: {}, topics: {}", (Object)transport.remoteAddress(), produceMessageRequest.getData().keySet());
            }
        }
        catch (InterruptedException e) {
            logger.error("wait produce exception, transport: {}", (Object)transport.remoteAddress(), (Object)e);
        }
        ProduceMessageResponse produceMessageResponse = new ProduceMessageResponse();
        produceMessageResponse.setTraffic(traffic);
        produceMessageResponse.setData(resultData);
        return new Command((Object)produceMessageResponse);
    }

    protected void produceMessage(Connection connection, String topic, String app, ProduceMessageData produceMessageData, EventListener<ProduceMessageAckData> listener) {
        Producer producer = new Producer(connection.getId(), topic, app, Producer.ProducerType.JOYQUEUE);
        try {
            this.produce.putMessageAsync(producer, produceMessageData.getMessages(), produceMessageData.getQosLevel(), produceMessageData.getTimeout(), writeResult -> {
                if (!writeResult.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                    logger.error("produce message failed, topic: {}, code: {}", (Object)producer.getTopic(), (Object)writeResult.getCode());
                }
                ProduceMessageAckData produceMessageAckData = new ProduceMessageAckData();
                produceMessageAckData.setCode(writeResult.getCode());
                produceMessageAckData.setItem(this.buildResponse(produceMessageData.getMessages(), (WriteResult)writeResult));
                listener.onEvent((Object)produceMessageAckData);
            });
        }
        catch (JoyQueueException e) {
            logger.error("produceMessage exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), topic, app, e});
            listener.onEvent((Object)this.buildResponse(produceMessageData, JoyQueueCode.valueOf((int)e.getCode())));
        }
        catch (Exception e) {
            logger.error("produceMessage exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), topic, app, e});
            listener.onEvent((Object)this.buildResponse(produceMessageData, JoyQueueCode.CN_UNKNOWN_ERROR));
        }
    }

    protected void checkAndFillMessage(Connection connection, ProduceMessageData produceMessageData) throws JoyQueueException {
        if (CollectionUtils.isEmpty((Collection)produceMessageData.getMessages())) {
            throw new JoyQueueException(JoyQueueCode.CN_PARAM_ERROR, new Object[]{"messages not empty"});
        }
        byte[] address = connection.getAddress();
        String txId = produceMessageData.getTxId();
        short partition = ((BrokerMessage)produceMessageData.getMessages().get(0)).getPartition();
        for (BrokerMessage brokerMessage : produceMessageData.getMessages()) {
            if (brokerMessage.getPartition() != partition) {
                throw new JoyQueueException(JoyQueueCode.CN_PARAM_ERROR, new Object[]{"the put message command has multi partition"});
            }
            if (ArrayUtils.getLength((Object)brokerMessage.getByteBody()) > this.produceConfig.getBodyLength()) {
                throw new JoyQueueException(JoyQueueCode.CN_PARAM_ERROR, new Object[]{"message body out of rage"});
            }
            if (StringUtils.length((CharSequence)brokerMessage.getBusinessId()) > this.produceConfig.getBusinessIdLength()) {
                throw new JoyQueueException(JoyQueueCode.CN_PARAM_ERROR, new Object[]{"message businessId out of rage"});
            }
            brokerMessage.setClientIp(address);
            brokerMessage.setTxId(txId);
        }
    }

    protected List<ProduceMessageAckItemData> buildResponse(List<BrokerMessage> messages, WriteResult writeResult) {
        BrokerMessage firstMessage = messages.get(0);
        LinkedList item = Lists.newLinkedList();
        if (firstMessage.isBatch()) {
            if (ArrayUtils.isEmpty((long[])writeResult.getIndices())) {
                item.add(new ProduceMessageAckItemData(firstMessage.getPartition(), -1L, firstMessage.getStartTime()));
            } else {
                item.add(new ProduceMessageAckItemData(firstMessage.getPartition(), writeResult.getIndices()[0], firstMessage.getStartTime()));
            }
        } else if (ArrayUtils.isEmpty((long[])writeResult.getIndices())) {
            for (BrokerMessage message : messages) {
                item.add(new ProduceMessageAckItemData(message.getPartition(), -1L, message.getStartTime()));
            }
        } else {
            for (int i = 0; i < writeResult.getIndices().length; ++i) {
                BrokerMessage message = messages.get(i);
                item.add(new ProduceMessageAckItemData(message.getPartition(), writeResult.getIndices()[i], message.getStartTime()));
            }
        }
        return item;
    }

    protected ProduceMessageAckData buildResponse(ProduceMessageData produceMessageData, JoyQueueCode code) {
        BrokerMessage firstMessage = (BrokerMessage)produceMessageData.getMessages().get(0);
        LinkedList item = Lists.newLinkedList();
        if (firstMessage.isBatch()) {
            item.add(ProduceMessageAckItemData.INVALID_INSTANCE);
        } else {
            for (int i = 0; i < produceMessageData.getMessages().size(); ++i) {
                item.add(ProduceMessageAckItemData.INVALID_INSTANCE);
            }
        }
        return new ProduceMessageAckData((List)item, code);
    }

    public int type() {
        return JoyQueueCommandType.PRODUCE_MESSAGE_REQUEST.getCode();
    }
}

