/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.helper.SessionHelper;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.converter.CheckResultConverter;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerCommit;
import org.joyqueue.message.JoyQueueLog;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.ProduceMessageRollbackRequest;
import org.joyqueue.network.command.ProduceMessageRollbackResponse;
import org.joyqueue.network.session.Connection;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.response.BooleanResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduceMessageRollbackRequestHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(ProduceMessageRollbackRequestHandler.class);
    private Produce produce;
    private ClusterManager clusterManager;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.produce = brokerContext.getProduce();
        this.clusterManager = brokerContext.getClusterManager();
    }

    public Command handle(Transport transport, Command command) {
        ProduceMessageRollbackRequest produceMessageRollbackRequest = (ProduceMessageRollbackRequest)command.getPayload();
        Connection connection = SessionHelper.getConnection((Transport)transport);
        if (connection == null || !connection.isAuthorized(produceMessageRollbackRequest.getApp())) {
            logger.warn("connection is not exists, transport: {}, app: {}", (Object)transport, (Object)produceMessageRollbackRequest.getApp());
            return BooleanAck.build((int)JoyQueueCode.FW_CONNECTION_NOT_EXISTS.getCode());
        }
        BooleanResponse checkResult = this.clusterManager.checkWritable(TopicName.parse((String)produceMessageRollbackRequest.getTopic()), produceMessageRollbackRequest.getApp(), connection.getHost());
        if (!checkResult.isSuccess()) {
            logger.warn("checkWritable failed, transport: {}, topic: {}, app: {}, code: {}", new Object[]{transport, produceMessageRollbackRequest.getTopic(), produceMessageRollbackRequest.getApp(), checkResult.getJoyQueueCode()});
            return new Command((Object)new ProduceMessageRollbackResponse(CheckResultConverter.convertCommonCode(command.getHeader().getVersion(), checkResult.getJoyQueueCode())));
        }
        ProduceMessageRollbackResponse produceMessageRollbackResponse = this.produceMessageRollback(connection, produceMessageRollbackRequest);
        return new Command((Object)produceMessageRollbackResponse);
    }

    protected ProduceMessageRollbackResponse produceMessageRollback(Connection connection, ProduceMessageRollbackRequest produceMessageRollbackRequest) {
        Producer producer = new Producer(connection.getId(), produceMessageRollbackRequest.getTopic(), produceMessageRollbackRequest.getApp(), Producer.ProducerType.JOYQUEUE);
        BrokerCommit brokerCommit = new BrokerCommit();
        brokerCommit.setTopic(produceMessageRollbackRequest.getTopic());
        brokerCommit.setApp(produceMessageRollbackRequest.getApp());
        brokerCommit.setTxId(produceMessageRollbackRequest.getTxId());
        try {
            this.produce.putTransactionMessage(producer, (JoyQueueLog)brokerCommit);
            return new ProduceMessageRollbackResponse(JoyQueueCode.SUCCESS);
        }
        catch (JoyQueueException e) {
            logger.error("produceMessage rollback exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), produceMessageRollbackRequest.getTopic(), produceMessageRollbackRequest.getApp(), e});
            return new ProduceMessageRollbackResponse(JoyQueueCode.valueOf((int)e.getCode()));
        }
        catch (Exception e) {
            logger.error("produceMessage rollback exception, transport: {}, topic: {}, app: {}", new Object[]{connection.getTransport().remoteAddress(), produceMessageRollbackRequest.getTopic(), produceMessageRollbackRequest.getApp(), e});
            return new ProduceMessageRollbackResponse(JoyQueueCode.CN_UNKNOWN_ERROR);
        }
    }

    public int type() {
        return JoyQueueCommandType.PRODUCE_MESSAGE_ROLLBACK_REQUEST.getCode();
    }
}

