/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.handler.mqtt;

import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.domain.Subscription;
import org.joyqueue.network.command.GetTopics;
import org.joyqueue.network.command.GetTopicsAck;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.nsr.NameService;

public class GetTopicsHandler
implements JoyQueueCommandHandler,
Type,
BrokerContextAware {
    private NameService nameService;

    public int type() {
        return JoyQueueCommandType.MQTT_GET_TOPICS.getCode();
    }

    public void setBrokerContext(BrokerContext brokerContext) {
        this.nameService = brokerContext.getNameService();
    }

    public Command handle(Transport transport, Command command) throws TransportException {
        GetTopics getTopics = (GetTopics)command.getPayload();
        HashSet topics = new HashSet();
        if (StringUtils.isBlank((CharSequence)getTopics.getApp())) {
            topics.addAll(this.nameService.getAllTopicCodes());
        } else {
            topics.addAll(this.nameService.getTopics(getTopics.getApp(), Subscription.Type.valueOf((byte)((byte)getTopics.getSubscribeType()))));
        }
        return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, (int)JoyQueueCommandType.MQTT_GET_TOPICS_ACK.getCode()), (Object)new GetTopicsAck().topics(topics));
    }
}

