/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.network;

import com.google.common.collect.Lists;
import com.jd.laf.extension.ExtensionManager;
import java.util.List;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.protocol.JoyQueueCommandHandler;
import org.joyqueue.broker.protocol.JoyQueueContext;
import org.joyqueue.broker.protocol.JoyQueueContextAware;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.support.DefaultCommandHandlerFactory;

public class JoyQueueCommandHandlerFactory
extends DefaultCommandHandlerFactory {
    private JoyQueueContext joyQueueContext;
    private List<JoyQueueCommandHandler> commandHandlers;

    public JoyQueueCommandHandlerFactory(JoyQueueContext joyQueueContext) {
        this.joyQueueContext = joyQueueContext;
        this.commandHandlers = this.loadCommandHandlers();
        this.initCommandHandlers(this.commandHandlers);
        this.registerCommandHandlers(this.commandHandlers);
    }

    protected List<JoyQueueCommandHandler> loadCommandHandlers() {
        return Lists.newArrayList((Iterable)ExtensionManager.getOrLoadExtensions(JoyQueueCommandHandler.class));
    }

    protected void initCommandHandlers(List<JoyQueueCommandHandler> commandHandlers) {
        for (JoyQueueCommandHandler commandHandler : commandHandlers) {
            if (commandHandler instanceof BrokerContextAware) {
                ((BrokerContextAware)commandHandler).setBrokerContext(this.joyQueueContext.getBrokerContext());
            }
            if (!(commandHandler instanceof JoyQueueContextAware)) continue;
            ((JoyQueueContextAware)((Object)commandHandler)).setJoyQueueContext(this.joyQueueContext);
        }
    }

    protected void registerCommandHandlers(List<JoyQueueCommandHandler> commandHandlers) {
        for (JoyQueueCommandHandler commandHandler : commandHandlers) {
            super.register((CommandHandler)commandHandler);
        }
    }
}

