/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.network;

import java.util.concurrent.RejectedExecutionException;
import org.joyqueue.broker.protocol.exception.JoyQueueException;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoyQueueExceptionHandler
implements ExceptionHandler {
    protected static final Logger logger = LoggerFactory.getLogger(JoyQueueExceptionHandler.class);

    public void handle(Transport transport, Command command, Throwable throwable) {
        if (throwable instanceof RejectedExecutionException) {
            logger.error("process command exception, header: {}, payload: {}, transport: {}, exception: {}", new Object[]{command.getHeader(), command.getPayload(), transport, throwable.getMessage()});
        } else {
            logger.error("process command exception, header: {}, payload: {}, transport: {}", new Object[]{command.getHeader(), command.getPayload(), transport, throwable});
        }
        if (command.getHeader().getQosLevel().equals((Object)QosLevel.ONE_WAY)) {
            return;
        }
        try {
            int code = JoyQueueCode.CN_UNKNOWN_ERROR.getCode();
            String error = null;
            if (throwable instanceof TransportException) {
                TransportException transportException = (TransportException)throwable;
                code = transportException.getCode();
                error = transportException.getMessage();
            } else if (throwable instanceof JoyQueueException) {
                JoyQueueException joyQueueException = (JoyQueueException)throwable;
                code = joyQueueException.getCode();
                error = joyQueueException.getMessage();
            } else if (throwable instanceof JoyQueueException) {
                JoyQueueException joyQueueException = (JoyQueueException)throwable;
                code = joyQueueException.getCode();
                error = joyQueueException.getMessage();
            }
            transport.acknowledge(command, BooleanAck.build((int)code, (String)error));
        }
        catch (Exception e) {
            logger.error("acknowledge command exception, header: {}, payload: {}, transport: {}", new Object[]{command.getHeader(), command.getPayload(), transport, e});
        }
    }
}

