/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.network;

import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.polling.LongPollingManager;
import org.joyqueue.broker.protocol.JoyQueueContext;
import org.joyqueue.broker.protocol.config.JoyQueueConfig;
import org.joyqueue.broker.protocol.coordinator.Coordinator;
import org.joyqueue.broker.protocol.coordinator.GroupMetadataManager;
import org.joyqueue.broker.protocol.coordinator.assignment.PartitionAssignmentHandler;
import org.joyqueue.broker.protocol.network.JoyQueueCodecFactory;
import org.joyqueue.broker.protocol.network.JoyQueueCommandHandlerFactory;
import org.joyqueue.broker.protocol.network.JoyQueueExceptionHandler;
import org.joyqueue.broker.protocol.network.helper.JoyQueueProtocolHelper;
import org.joyqueue.network.protocol.ExceptionHandlerProvider;
import org.joyqueue.network.protocol.ProtocolService;
import org.joyqueue.network.transport.codec.CodecFactory;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.toolkit.service.Service;

public class JoyQueueProtocol
extends Service
implements ProtocolService,
BrokerContextAware,
ExceptionHandlerProvider {
    private JoyQueueConfig config;
    private Coordinator coordinator;
    private GroupMetadataManager coordinatorGroupManager;
    private PartitionAssignmentHandler partitionAssignmentHandler;
    private LongPollingManager longPollingManager;
    private JoyQueueContext joyQueueContext;

    public void setBrokerContext(BrokerContext brokerContext) {
        this.config = new JoyQueueConfig(brokerContext.getPropertySupplier());
        this.coordinator = new Coordinator(brokerContext.getCoordinatorService().getCoordinator());
        this.coordinatorGroupManager = new GroupMetadataManager(this.config, brokerContext.getCoordinatorService().getOrCreateGroupMetadataManager("joyqueue"));
        this.partitionAssignmentHandler = new PartitionAssignmentHandler(this.config, this.coordinatorGroupManager);
        this.longPollingManager = new LongPollingManager(brokerContext.getSessionManager(), brokerContext.getClusterManager(), brokerContext.getConsume(), brokerContext.getPropertySupplier());
        this.joyQueueContext = new JoyQueueContext(this.config, this.coordinator, this.coordinatorGroupManager, this.partitionAssignmentHandler, this.longPollingManager, brokerContext);
    }

    protected void doStart() throws Exception {
        this.partitionAssignmentHandler.start();
        this.longPollingManager.start();
    }

    protected void doStop() {
        this.partitionAssignmentHandler.stop();
        this.longPollingManager.stop();
    }

    public boolean isSupport(ByteBuf buffer) {
        return JoyQueueProtocolHelper.isSupport(buffer);
    }

    public CodecFactory createCodecFactory() {
        return new JoyQueueCodecFactory();
    }

    public CommandHandlerFactory createCommandHandlerFactory() {
        return new JoyQueueCommandHandlerFactory(this.joyQueueContext);
    }

    public String type() {
        return "joyqueue";
    }

    public ExceptionHandler getExceptionHandler() {
        return new JoyQueueExceptionHandler();
    }
}

