/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.network.codec;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.protocol.command.FetchPartitionMessageRequest;
import org.joyqueue.broker.protocol.network.codec.JoyQueuePayloadCodec;
import org.joyqueue.network.command.FetchPartitionMessageData;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;

public class FetchPartitionMessageRequestCodec
extends org.joyqueue.network.codec.FetchPartitionMessageRequestCodec
implements JoyQueuePayloadCodec<org.joyqueue.network.command.FetchPartitionMessageRequest> {
    public FetchPartitionMessageRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        HashBasedTable partitions = HashBasedTable.create();
        int topicSize = buffer.readShort();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitionSize = buffer.readShort();
            for (int j = 0; j < partitionSize; ++j) {
                short partition = buffer.readShort();
                int count = buffer.readInt();
                long index = buffer.readLong();
                partitions.put((Object)topic, (Object)partition, (Object)new FetchPartitionMessageData(count, index));
            }
        }
        FetchPartitionMessageRequest fetchPartitionMessageRequest = new FetchPartitionMessageRequest();
        fetchPartitionMessageRequest.setPartitions((Table<String, Short, FetchPartitionMessageData>)partitions);
        fetchPartitionMessageRequest.setApp(Serializer.readString((ByteBuf)buffer, (int)2));
        return fetchPartitionMessageRequest;
    }
}

