/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.protocol.network.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.protocol.network.codec.JoyQueueDecoder;
import org.joyqueue.broker.protocol.network.codec.JoyQueueEncoder;
import org.joyqueue.network.command.JoyQueuePayloadCodecRegistry;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.Decoder;
import org.joyqueue.network.transport.codec.Encoder;
import org.joyqueue.network.transport.codec.JoyQueueHeaderCodec;
import org.joyqueue.network.transport.codec.PayloadCodecFactory;
import org.joyqueue.network.transport.exception.TransportException;

public class JoyQueueCodec
implements Codec {
    private Codec headerCodec;
    private PayloadCodecFactory payloadCodecFactory;
    private Decoder decoder;
    private Encoder encoder;

    public JoyQueueCodec() {
        PayloadCodecFactory payloadCodecFactory = new PayloadCodecFactory();
        JoyQueuePayloadCodecRegistry.register((PayloadCodecFactory)payloadCodecFactory);
        this.headerCodec = new JoyQueueHeaderCodec();
        this.payloadCodecFactory = payloadCodecFactory;
        this.decoder = new JoyQueueDecoder(this.headerCodec, payloadCodecFactory);
        this.encoder = new JoyQueueEncoder(this.headerCodec, payloadCodecFactory);
    }

    public JoyQueueCodec(PayloadCodecFactory payloadCodecFactory) {
        this((Codec)new JoyQueueHeaderCodec(), payloadCodecFactory);
    }

    public JoyQueueCodec(Codec headerCodec, PayloadCodecFactory payloadCodecFactory) {
        this.headerCodec = headerCodec;
        this.payloadCodecFactory = payloadCodecFactory;
        this.decoder = new JoyQueueDecoder(headerCodec, payloadCodecFactory);
        this.encoder = new JoyQueueEncoder(headerCodec, payloadCodecFactory);
    }

    public Object decode(ByteBuf buffer) throws TransportException.CodecException {
        return this.decoder.decode(buffer);
    }

    public void encode(Object obj, ByteBuf buffer) throws TransportException.CodecException {
        this.encoder.encode(obj, buffer);
    }

    public PayloadCodecFactory getPayloadCodecFactory() {
        return this.payloadCodecFactory;
    }
}

