/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.store.StoreNode;

public class StoreNodes {
    private List<StoreNode> nodes;

    public StoreNodes() {
    }

    public StoreNodes(StoreNode node) {
        this(Lists.newArrayList((Object[])new StoreNode[]{node}));
    }

    public StoreNodes(List<StoreNode> nodes) {
        this.nodes = nodes;
    }

    public StoreNode getRWNode() {
        for (StoreNode node : this.nodes) {
            if (!node.isWritable() || !node.isReadable()) continue;
            return node;
        }
        return null;
    }

    public StoreNode getWritableNode() {
        for (StoreNode node : this.nodes) {
            if (!node.isWritable()) continue;
            return node;
        }
        return null;
    }

    public List<StoreNode> getReadableNodes() {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.nodes.size());
        for (StoreNode node : this.nodes) {
            if (!node.isReadable()) continue;
            result.add(node);
        }
        return result;
    }

    public List<StoreNode> getNodes() {
        return this.nodes;
    }
}

