/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.simple.DateTimeConverter;
import com.jd.laf.extension.Ordered;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class Date8Converter
extends DateTimeConverter<Date>
implements Ordered {
    @Override
    protected Date convert(TemporalAccessor temporal) {
        if (temporal instanceof Instant) {
            return Date.from((Instant)temporal);
        }
        if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
            long value = temporal.getLong(ChronoField.EPOCH_DAY) * 24L * 3600L * 1000L;
            if (temporal.isSupported(ChronoField.MILLI_OF_DAY)) {
                value += temporal.getLong(ChronoField.MILLI_OF_DAY);
            }
            return new Date(value);
        }
        return new Date(Instant.from(temporal).toEpochMilli());
    }

    public Class<?> targetType() {
        return Date.class;
    }

    public int order() {
        return 32766;
    }
}

