/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.SimpleConverter;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public abstract class DateTimeConverter<T>
implements SimpleConverter {
    public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public T execute(Conversion conversion) {
        try {
            if (conversion == null || conversion.source == null) {
                return null;
            }
            if (conversion.source instanceof Calendar) {
                return this.convert(((Calendar)conversion.source).toInstant());
            }
            if (conversion.source instanceof Date) {
                return this.convert(((Date)conversion.source).toInstant());
            }
            if (conversion.source instanceof Number) {
                return this.convert((Number)conversion.source);
            }
            if (conversion.source instanceof TemporalAccessor) {
                return this.convert((TemporalAccessor)conversion.source);
            }
            if (conversion.source instanceof CharSequence) {
                String format;
                String source = conversion.source.toString().trim();
                String string = format = conversion.format == null ? null : conversion.format.toString().trim();
                if (format != null && !format.isEmpty()) {
                    return this.convert(DateTimeFormatter.ofPattern(format).parse(source));
                }
                return this.guess(source);
            }
            if (conversion.source instanceof Character) {
                return this.convert(Long.parseLong(((Character)conversion.source).toString()));
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (DateTimeParseException dateTimeParseException) {
        }
        catch (DateTimeException dateTimeException) {
            // empty catch block
        }
        return null;
    }

    protected T guess(String source) {
        int slash = 0;
        int length = source.length();
        block6: for (int i = 0; i < length; ++i) {
            switch (source.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block6;
                }
                case '-': {
                    if (slash++ < 2) continue block6;
                    return null;
                }
                case ' ': {
                    return slash == 2 ? (T)this.convert(YYYY_MM_DD_HH_MM_SS.parse((CharSequence)source, LocalDateTime::from)) : null;
                }
                case 'T': {
                    return slash == 2 ? (T)this.convert(DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)source, LocalDateTime::from)) : null;
                }
                default: {
                    return null;
                }
            }
        }
        return slash == 2 ? (T)this.convert(DateTimeFormatter.ISO_DATE.parse((CharSequence)source, LocalDate::from)) : (slash == 0 ? (T)this.convert(Long.parseLong(source)) : null);
    }

    protected T convert(Number number) {
        return this.convert(Instant.ofEpochMilli(number.longValue()));
    }

    protected abstract T convert(TemporalAccessor var1);

    public boolean support(Class<?> sourceType) {
        if (sourceType == null) {
            return false;
        }
        if (Calendar.class.isAssignableFrom(sourceType)) {
            return true;
        }
        if (Date.class.isAssignableFrom(sourceType)) {
            return true;
        }
        if (Number.class.isAssignableFrom(sourceType)) {
            return true;
        }
        if (Character.class.isAssignableFrom(sourceType)) {
            return true;
        }
        return CharSequence.class.isAssignableFrom(sourceType);
    }
}

